/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import reliquary.network.SpawnConcussiveExplosionParticlesPayload;
import reliquary.util.RandHelper;

public class ConcussiveExplosion
extends ServerExplosion {
    protected final Level level;
    protected final Vec3 pos;
    protected final Entity exploder;
    protected float explosionSize;
    private final Map<Player, Vec3> playerKnockbackMap;
    private final Player shootingEntity;

    public ConcussiveExplosion(ServerLevel level, @Nullable Entity entity, @Nullable Player player, Vec3 pos, float size, boolean isFlaming) {
        super(level, entity, null, null, pos, size, isFlaming, Explosion.BlockInteraction.DESTROY);
        this.level = level;
        this.exploder = entity;
        this.shootingEntity = player;
        this.pos = pos;
        this.explosionSize = size;
        this.playerKnockbackMap = Maps.newHashMap();
    }

    public void explode() {
        float var1 = this.explosionSize;
        this.explosionSize *= 2.0f;
        List var9 = this.level.getEntities(this.exploder, new AABB(this.pos.add((double)(-this.explosionSize) - 1.0, (double)(-this.explosionSize) - 1.0, (double)(-this.explosionSize) - 1.0), this.pos.add((double)this.explosionSize + 1.0, (double)this.explosionSize + 1.0, (double)this.explosionSize + 1.0)));
        for (Entity entity : var9) {
            if (!this.affectEntity(entity)) continue;
            this.attackEntityWithExplosion(this.pos, entity);
        }
        this.explosionSize = var1;
    }

    private void attackEntityWithExplosion(Vec3 var30, Entity entity) {
        double d9;
        double d7;
        double d5;
        double var33;
        double var13 = Math.sqrt(entity.distanceToSqr(this.pos)) / (double)this.explosionSize;
        if (var13 <= 1.0 && (var33 = Math.sqrt((d5 = entity.getX() - this.pos.x()) * d5 + (d7 = entity.getY() + (double)entity.getEyeHeight() - this.pos.y()) * d7 + (d9 = entity.getZ() - this.pos.z()) * d9)) != 0.0) {
            d5 /= var33;
            d7 /= var33;
            d9 /= var33;
            double var32 = ConcussiveExplosion.getSeenPercent((Vec3)var30, (Entity)entity);
            double d10 = (1.0 - var13) * var32;
            Level level = entity.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                entity.hurtServer(serverLevel, entity.damageSources().thrown(this.exploder, (Entity)this.shootingEntity), (float)((int)((d10 * d10 + d10) * 6.0 * (double)(this.explosionSize * 2.0f) + 3.0)));
            }
            entity.setDeltaMovement(entity.getDeltaMovement().add(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    protected boolean affectEntity(Entity entity) {
        return entity instanceof Mob;
    }

    public static void finalizeExplosion(Vec3 pos, Level level, float explosionSize) {
        level.playSound(null, BlockPos.containing((double)pos.x(), (double)pos.y(), (double)pos.z()), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 4.0f, (1.0f + RandHelper.getRandomMinusOneToOne(level.random) * 0.2f) * 0.7f);
        if (explosionSize >= 2.0f) {
            level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, pos.x(), pos.y(), pos.z(), 1.0, 0.0, 0.0);
        } else {
            level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, pos.x(), pos.y(), pos.z(), 1.0, 0.0, 0.0);
        }
    }

    public Map<Player, Vec3> getHitPlayers() {
        return this.playerKnockbackMap;
    }

    public static void customBusterExplosion(Entity par1Entity, double x, double y, double z, float par8) {
        if (par1Entity.level().isClientSide) {
            return;
        }
        par1Entity.level().explode(par1Entity, x, y, z, par8, false, Level.ExplosionInteraction.BLOCK);
    }

    public static void customConcussiveExplosion(Entity entity, Player player, Vec3 pos, float size, boolean isFlaming) {
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ConcussiveExplosion explosion = new ConcussiveExplosion(serverLevel, entity, player, pos, size, isFlaming);
        explosion.explode();
        ConcussiveExplosion.finalizeExplosion(explosion.pos, explosion.level, explosion.explosionSize);
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new SpawnConcussiveExplosionParticlesPayload(size, pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    static void grenadeConcussiveExplosion(Entity entity, Player player, Vec3 pos) {
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        GrenadeConcussiveExplosion explosion = new GrenadeConcussiveExplosion(serverLevel, entity, player, pos);
        explosion.explode();
        ConcussiveExplosion.finalizeExplosion(explosion.pos, explosion.level, explosion.explosionSize);
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new SpawnConcussiveExplosionParticlesPayload(4.0f, pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static class GrenadeConcussiveExplosion
    extends ConcussiveExplosion {
        GrenadeConcussiveExplosion(ServerLevel level, Entity entity, Player par3Entity, Vec3 pos) {
            super(level, entity, par3Entity, pos, 4.0f, false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean affectEntity(Entity entity) {
            if (super.affectEntity(entity)) {
                if (!(entity instanceof Player)) return true;
            }
            if (!(entity instanceof Player)) return false;
            Player player = (Player)entity;
            if (this.exploder == null) return false;
            if (this.exploder.getCustomName() == null) return false;
            if (!this.exploder.getCustomName().getString().contains(player.getGameProfile().getName())) return false;
            return true;
        }
    }
}

