/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import reliquary.init.ModEffects;
import reliquary.init.ModEntities;

public class KrakenSlime
extends ThrowableItemProjectile {
    public KrakenSlime(EntityType<KrakenSlime> entityType, Level level) {
        super(entityType, level);
    }

    public KrakenSlime(Level level, Player player) {
        super(ModEntities.KRAKEN_SLIME.get(), player.getX(), player.getEyeY() - 0.1, player.getZ(), level, new ItemStack((ItemLike)Items.SLIME_BALL));
        this.setOwner((Entity)player);
    }

    protected void onHit(HitResult result) {
        Entity entity;
        Entity thrower = this.getOwner();
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (result.getType() == HitResult.Type.ENTITY && ((EntityHitResult)result).getEntity() == thrower) {
            return;
        }
        if (result.getType() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)result).getEntity()) instanceof Mob) {
            Mob living = (Mob)entity;
            living.hurtServer(serverLevel, this.damageSources().thrown((Entity)this, thrower), 5.0f);
            living.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 400, 2));
            living.addEffect(new MobEffectInstance(ModEffects.PACIFICATION, 300));
        }
        double motionX = this.getDeltaMovement().x();
        double motionY = this.getDeltaMovement().y();
        double motionZ = this.getDeltaMovement().z();
        for (int count = 0; count < 6; ++count) {
            float amplifier = 0.25f;
            this.level().addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, this.getX() - motionX * (double)amplifier + this.level().random.nextDouble(), this.getY() - motionY * (double)amplifier + this.level().random.nextDouble(), this.getZ() - motionZ * (double)amplifier + this.level().random.nextDouble(), motionX, motionY, motionZ);
        }
        this.level().playSound(null, this.blockPosition(), SoundEvents.SLIME_JUMP, SoundSource.NEUTRAL, 0.5f, 0.4f / (this.level().random.nextFloat() * 0.4f + 0.8f));
        this.discard();
    }

    protected double getDefaultGravity() {
        return 0.001f;
    }

    protected Item getDefaultItem() {
        return Items.SLIME_BALL;
    }

    public void tick() {
        super.tick();
        double motionX = this.getDeltaMovement().x();
        double motionY = this.getDeltaMovement().y();
        double motionZ = this.getDeltaMovement().z();
        for (int count = 0; count < 2; ++count) {
            float amplifier = 0.25f;
            this.level().addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, this.getX() - motionX * (double)amplifier, this.getY() - motionY * (double)amplifier, this.getZ() - motionZ * (double)amplifier, motionX, motionY, motionZ);
        }
        if (this.level().isClientSide) {
            return;
        }
        if (motionX < 0.5 && motionY == 0.0 && motionZ == 0.0) {
            this.discard();
            return;
        }
        if (this.getY() > (double)this.level().getMaxY() || this.getY() <= 0.0) {
            this.discard();
        }
    }
}

