/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity.shot;

import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import reliquary.entity.shot.ShotBase;
import reliquary.init.ModEntities;

public class SeekerShot
extends ShotBase {
    public SeekerShot(EntityType<SeekerShot> entityType, Level level) {
        super(entityType, level);
    }

    public SeekerShot(Level level, Player player, InteractionHand hand) {
        super(ModEntities.SEEKER_SHOT.get(), level, player, hand);
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0) {
            this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.0f, (float)this.gaussian(1.0f), (float)this.gaussian(1.0f)), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
        this.seekTarget();
    }

    @Override
    void doFiringEffects() {
        this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.5f, (float)0.5f, (float)0.5f), this.getX() + this.smallGauss(0.1), this.getY() + this.smallGauss(0.1), this.getZ() + this.smallGauss(0.1), 0.0, 0.0, 0.0);
        this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.FLAME);
    }

    @Override
    void doBurstEffect(Direction sideHit) {
    }

    @Override
    void spawnHitParticles(int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.1f, (float)1.0f, (float)1.0f), this.getX() + this.smallGauss(0.1), this.getY() + this.smallGauss(0.1), this.getZ() + this.smallGauss(0.1), 0.0, 0.0, 0.0);
        }
    }

    @Override
    int getRicochetMax() {
        return 3;
    }

    @Override
    int getDamageOfShot(LivingEntity mop) {
        return 10 + this.d12();
    }
}

