/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity.shot;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import reliquary.entity.shot.ShotBase;
import reliquary.init.ModEntities;

public class StormShot
extends ShotBase {
    public StormShot(EntityType<StormShot> entityType, Level level) {
        super(entityType, level);
    }

    public StormShot(Level level, Player player, InteractionHand hand) {
        super(ModEntities.STORM_SHOT.get(), level, player, hand);
    }

    @Override
    void doFiringEffects() {
        this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.5f, (float)0.5f, (float)0.5f), this.getX() + this.smallGauss(0.1), this.getY() + this.smallGauss(0.1), this.getZ() + this.smallGauss(0.1), 0.0, 0.0, 0.0);
        this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.FLAME);
    }

    @Override
    void doFlightEffects() {
    }

    @Override
    protected void onHit(HitResult result) {
        if (result.getType() == HitResult.Type.BLOCK) {
            LightningBolt bolt;
            BlockHitResult blockResult = (BlockHitResult)result;
            BlockPos pos = blockResult.getBlockPos().relative(blockResult.getDirection());
            if (this.level() instanceof ServerLevel && this.level().isRainingAt(pos) && this.level().getLevelData().isRaining() && this.level().getLevelData().isThundering() && (bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level(), EntitySpawnReason.EVENT)) != null) {
                bolt.snapTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                this.level().addFreshEntity((Entity)bolt);
            }
        }
        super.onHit(result);
    }

    @Override
    void doBurstEffect(Direction sideHit) {
    }

    @Override
    void spawnHitParticles(int i) {
        Vec3 motion = this.getDeltaMovement();
        for (int particles = 0; particles < i; ++particles) {
            this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX(), this.getY(), this.getZ(), this.gaussian(motion.x()), (double)this.random.nextFloat() + motion.y(), this.gaussian(motion.z()));
        }
    }

    @Override
    int getRicochetMax() {
        return 1;
    }

    @Override
    void doDamage(LivingEntity entity) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            LightningBolt bolt;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.level().isRainingAt(entity.blockPosition()) && this.level().getLevelData().isRaining() && this.level().getLevelData().isThundering() && (bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level(), EntitySpawnReason.EVENT)) != null) {
                bolt.snapTo(entity.getX(), entity.getY(), entity.getZ());
                this.level().addFreshEntity((Entity)bolt);
                if (entity instanceof Creeper) {
                    entity.thunderHit(serverLevel, bolt);
                }
            }
        }
        super.doDamage(entity);
    }

    @Override
    int getDamageOfShot(LivingEntity entity) {
        float f = 1.0f + (this.level().isRaining() ? 0.5f : 0.0f) + (this.level().isThundering() ? 0.5f : 0.0f);
        return Math.round(9.0f * f) + this.d6();
    }
}

