/*
 * Decompiled with CFR 0.152.
 */
package reliquary.handler;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.FishingHookRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.locale.Language;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterConditionalItemModelPropertyEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterItemModelsEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.client.renderstate.RegisterRenderStateModifiersEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;
import reliquary.Reliquary;
import reliquary.client.color.item.CharmTintSources;
import reliquary.client.gui.components.Box;
import reliquary.client.gui.components.Component;
import reliquary.client.gui.components.ItemStackPane;
import reliquary.client.gui.components.TextPane;
import reliquary.client.gui.hud.ChargePane;
import reliquary.client.gui.hud.ChargeableItemInfoPane;
import reliquary.client.gui.hud.CharmPane;
import reliquary.client.gui.hud.DynamicChargePane;
import reliquary.client.gui.hud.HUDPosition;
import reliquary.client.gui.hud.HUDRenderrer;
import reliquary.client.gui.hud.HandgunPane;
import reliquary.client.gui.hud.HeroMedallionPane;
import reliquary.client.init.ModBlockColors;
import reliquary.client.init.ModParticles;
import reliquary.client.model.MobCharmBeltModel;
import reliquary.client.model.VoidTearItemModel;
import reliquary.client.model.WitchHatModel;
import reliquary.client.registry.PedestalClientRegistry;
import reliquary.client.render.ApothecaryMortarRenderer;
import reliquary.client.render.PassivePedestalRenderer;
import reliquary.client.render.PedestalFishHookRenderer;
import reliquary.client.render.PedestalRenderer;
import reliquary.client.render.ShotRenderer;
import reliquary.client.render.TippedArrowRenderer;
import reliquary.init.ModBlocks;
import reliquary.init.ModEntities;
import reliquary.init.ModFluids;
import reliquary.init.ModItems;
import reliquary.item.AlkahestryTomeItem;
import reliquary.item.DestructionCatalystItem;
import reliquary.item.EnderStaffItem;
import reliquary.item.FortuneCoinToggler;
import reliquary.item.HarvestRodItem;
import reliquary.item.IceMagusRodItem;
import reliquary.item.InfernalChaliceItem;
import reliquary.item.MidasTouchstoneItem;
import reliquary.item.PyromancerStaffItem;
import reliquary.item.RendingGaleItem;
import reliquary.item.RodOfLyssaItem;
import reliquary.item.VoidTearItem;
import reliquary.item.properties.conditional.InfernalTearEmpty;
import reliquary.item.properties.conditional.LyssaRodCast;
import reliquary.item.util.IScrollableItem;
import reliquary.network.ScrolledItemPayload;
import reliquary.reference.ClientReference;
import reliquary.reference.Colors;
import reliquary.reference.Config;
import reliquary.util.InventoryHelper;

public class ClientEventHandler {
    private static final int KEY_UNKNOWN = -1;
    public static final KeyMapping FORTUNE_COIN_TOGGLE_KEYBIND = new KeyMapping("keybind.reliquary.fortune_coin", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputConstants.Type.KEYSYM.getOrCreate(-1), "keybind.reliquary.category");
    private static final String VOID_TEAR_MODE_TRANSLATION = "item.reliquary.void_tear.mode.";
    public static final ModelLayerLocation WITCH_HAT_LAYER = new ModelLayerLocation(Reliquary.getRL("witch_hat"), "main");
    public static final ModelLayerLocation MOB_CHARM_BELT_LAYER = new ModelLayerLocation(Reliquary.getRL("mob_charm_belt"), "main");
    private static final List<Tuple<Component, HUDPosition>> hudComponents = Lists.newArrayList();

    private ClientEventHandler() {
    }

    public static void registerHandlers() {
        IEventBus modBus = ModLoadingContext.get().getActiveContainer().getEventBus();
        if (modBus == null) {
            return;
        }
        modBus.addListener(ClientEventHandler::registerKeyMappings);
        modBus.addListener(ClientEventHandler::loadComplete);
        modBus.addListener(ModParticles.ProviderHandler::registerProviders);
        modBus.addListener(ClientEventHandler::registerEntityRenderers);
        modBus.addListener(ClientEventHandler::registerLayer);
        modBus.addListener(ModBlockColors::registerBlockColors);
        modBus.addListener(ClientEventHandler::registerOverlay);
        modBus.addListener(ClientEventHandler::registerWitchHatClientExtension);
        modBus.addListener(ClientEventHandler::registerVoidTearItemModel);
        modBus.addListener(ClientEventHandler::registerConditionalItemModelProperties);
        modBus.addListener(ClientEventHandler::registerTintSources);
        modBus.addListener(ClientEventHandler::registerMovingStorageRenderStateModifiers);
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(ClientEventHandler::onMouseScrolled);
    }

    private static void registerTintSources(RegisterColorHandlersEvent.ItemTintSources event) {
        event.register(Reliquary.getRL("charm_main_tint"), CharmTintSources.Main.MAP_CODEC);
        event.register(Reliquary.getRL("charm_accent_tint"), CharmTintSources.Accent.MAP_CODEC);
    }

    private static void registerVoidTearItemModel(RegisterItemModelsEvent event) {
        event.register(Reliquary.getRL("void_tear"), VoidTearItemModel.Unbaked.MAP_CODEC);
    }

    private static void registerMovingStorageRenderStateModifiers(RegisterRenderStateModifiersEvent event) {
        event.registerEntityModifier(PlayerRenderer.class, (player, playerRenderState) -> {
            HumanoidArm primaryHand = player.getMainArm();
            if (ClientEventHandler.isActiveHandgun((Player)player, player.getMainHandItem())) {
                if (primaryHand == HumanoidArm.RIGHT && playerRenderState.rightArmPose != HumanoidModel.ArmPose.BOW_AND_ARROW) {
                    playerRenderState.rightArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
                } else if (primaryHand == HumanoidArm.LEFT && playerRenderState.leftArmPose != HumanoidModel.ArmPose.BOW_AND_ARROW) {
                    playerRenderState.leftArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
                }
            } else if (ClientEventHandler.isActiveHandgun((Player)player, player.getOffhandItem())) {
                if (primaryHand == HumanoidArm.RIGHT && playerRenderState.leftArmPose != HumanoidModel.ArmPose.BOW_AND_ARROW) {
                    playerRenderState.leftArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
                } else if (primaryHand == HumanoidArm.LEFT && playerRenderState.rightArmPose != HumanoidModel.ArmPose.BOW_AND_ARROW) {
                    playerRenderState.rightArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
                }
            }
        });
    }

    private static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(WITCH_HAT_LAYER, WitchHatModel::createBodyLayer);
        event.registerLayerDefinition(MOB_CHARM_BELT_LAYER, MobCharmBeltModel::createBodyLayer);
    }

    private static boolean isActiveHandgun(Player player, ItemStack stack) {
        Level level;
        if (stack.getItem() != ModItems.HANDGUN.get()) {
            return false;
        }
        long cooldownTime = ModItems.HANDGUN.get().getCooldown(stack) + 5L;
        return cooldownTime - (level = player.level()).getGameTime() <= (long)ModItems.HANDGUN.get().getUseDuration(stack, (LivingEntity)player) && cooldownTime >= level.getGameTime();
    }

    private static void registerOverlay(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.HOTBAR, Reliquary.getRL("reliquary_hud"), (guiGraphics, deltaTracker) -> {
            if (hudComponents.isEmpty()) {
                ClientEventHandler.initHUDComponents();
            }
            ClientEventHandler.renderHUDComponents(guiGraphics);
        });
    }

    private static void onMouseScrolled(InputEvent.MouseScrollingEvent evt) {
        IScrollableItem scrollableItem;
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null || !Screen.hasShiftDown()) {
            return;
        }
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        double scrollDelta = evt.getScrollDeltaY();
        Item item = stack.getItem();
        if (item instanceof IScrollableItem && (scrollableItem = (IScrollableItem)item).onMouseScrolled(stack, (Player)player, scrollDelta) == InteractionResult.PASS) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ScrolledItemPayload(scrollDelta), (CustomPacketPayload[])new CustomPacketPayload[0]);
            evt.setCanceled(true);
        }
    }

    private static void renderHUDComponents(GuiGraphics guiGraphics) {
        for (Tuple<Component, HUDPosition> component : hudComponents) {
            HUDRenderrer.render(guiGraphics, (Component)component.getA(), (HUDPosition)((Object)component.getB()));
        }
    }

    private static void initHUDComponents() {
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.ALKAHESTRY_TOME.get(), (HUDPosition)((Object)Config.CLIENT.hudPositions.alkahestryTome.get()), new ItemStack((ItemLike)Items.REDSTONE), AlkahestryTomeItem::getCharge), (Object)((HUDPosition)((Object)Config.CLIENT.hudPositions.alkahestryTome.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.DESTRUCTION_CATALYST.get(), (HUDPosition)((Object)Config.CLIENT.hudPositions.destructionCatalyst.get()), new ItemStack((ItemLike)Items.GUNPOWDER), DestructionCatalystItem::getGunpowder), (Object)((HUDPosition)((Object)Config.CLIENT.hudPositions.destructionCatalyst.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.MIDAS_TOUCHSTONE.get(), (HUDPosition)((Object)Config.CLIENT.hudPositions.midasTouchstone.get()), new ItemStack((ItemLike)Items.GLOWSTONE_DUST), MidasTouchstoneItem::getGlowstoneCharge), (Object)((HUDPosition)((Object)Config.CLIENT.hudPositions.midasTouchstone.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane(ModItems.INFERNAL_CHALICE.get(), (HUDPosition)((Object)Config.CLIENT.hudPositions.infernalChalice.get()), new ItemStack((ItemLike)Items.LAVA_BUCKET), InfernalChaliceItem::getFluidBucketAmount, Colors.get("CC3024")), (Object)((HUDPosition)((Object)Config.CLIENT.hudPositions.infernalChalice.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.ICE_MAGUS_ROD.get(), (HUDPosition)((Object)Config.CLIENT.hudPositions.iceMagusRod.get()), new ItemStack((ItemLike)Items.SNOWBALL), IceMagusRodItem::getSnowballs), (Object)((HUDPosition)((Object)Config.CLIENT.hudPositions.iceMagusRod.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.GLACIAL_STAFF.get(), (HUDPosition)((Object)Config.CLIENT.hudPositions.glacialStaff.get()), new ItemStack((ItemLike)Items.SNOWBALL), IceMagusRodItem::getSnowballs), (Object)((HUDPosition)((Object)Config.CLIENT.hudPositions.glacialStaff.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.ENDER_STAFF.get(), (HUDPosition)((Object)Config.CLIENT.hudPositions.enderStaff.get()), is -> ModItems.ENDER_STAFF.get().getMode((ItemStack)is).getSerializedName(), Map.of(EnderStaffItem.Mode.CAST.getSerializedName(), new ChargePane(ModItems.ENDER_STAFF.get(), new ItemStack((ItemLike)Items.ENDER_PEARL), is -> ModItems.ENDER_STAFF.get().getPearlCount((ItemStack)is)), EnderStaffItem.Mode.NODE_WARP.getSerializedName(), new ChargePane(ModItems.ENDER_STAFF.get(), new ItemStack((ItemLike)ModBlocks.WRAITH_NODE.get()), is -> ModItems.ENDER_STAFF.get().getPearlCount((ItemStack)is)), EnderStaffItem.Mode.LONG_CAST.getSerializedName(), new ChargePane(ModItems.ENDER_STAFF.get(), new ItemStack((ItemLike)Items.ENDER_EYE), is -> ModItems.ENDER_STAFF.get().getPearlCount((ItemStack)is)))), (Object)((HUDPosition)((Object)Config.CLIENT.hudPositions.enderStaff.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.PYROMANCER_STAFF.get(), (HUDPosition)((Object)Config.CLIENT.hudPositions.pyromancerStaff.get()), is -> ModItems.PYROMANCER_STAFF.get().getMode((ItemStack)is).getSerializedName(), Map.of(PyromancerStaffItem.Mode.BLAZE.getSerializedName(), new ChargePane(ModItems.PYROMANCER_STAFF.get(), new ItemStack((ItemLike)Items.BLAZE_POWDER), staff -> ModItems.PYROMANCER_STAFF.get().getBlazePowderCount((ItemStack)staff)), PyromancerStaffItem.Mode.FIRE_CHARGE.getSerializedName(), new ChargePane(ModItems.PYROMANCER_STAFF.get(), new ItemStack((ItemLike)Items.FIRE_CHARGE), staff -> ModItems.PYROMANCER_STAFF.get().getFireChargeCount((ItemStack)staff)), PyromancerStaffItem.Mode.ERUPTION.getSerializedName(), Box.createVertical(Box.Alignment.RIGHT, new TextPane("ERUPT"), new ChargePane(ModItems.PYROMANCER_STAFF.get(), new ItemStack((ItemLike)Items.BLAZE_POWDER), staff -> ModItems.PYROMANCER_STAFF.get().getBlazePowderCount((ItemStack)staff))), PyromancerStaffItem.Mode.FLINT_AND_STEEL.getSerializedName(), new ItemStackPane(Items.FLINT_AND_STEEL))), (Object)((HUDPosition)((Object)Config.CLIENT.hudPositions.pyromancerStaff.get()))));
        ChargePane rendingGaleFeatherPane = new ChargePane(ModItems.RENDING_GALE.get(), new ItemStack((ItemLike)Items.FEATHER), is -> {
            LocalPlayer player = Minecraft.getInstance().player;
            return player == null ? 0 : ModItems.RENDING_GALE.get().getFeatherCount((ItemStack)is);
        });
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.RENDING_GALE.get(), (HUDPosition)((Object)Config.CLIENT.hudPositions.rendingGale.get()), is -> ModItems.RENDING_GALE.get().getMode((ItemStack)is).getSerializedName(), Map.of(RendingGaleItem.Mode.PUSH.getSerializedName(), Box.createVertical(Box.Alignment.RIGHT, new TextPane("PUSH"), rendingGaleFeatherPane), RendingGaleItem.Mode.PULL.getSerializedName(), Box.createVertical(Box.Alignment.RIGHT, new TextPane("PULL"), rendingGaleFeatherPane), RendingGaleItem.Mode.BOLT.getSerializedName(), Box.createVertical(Box.Alignment.RIGHT, new TextPane("BOLT"), rendingGaleFeatherPane), RendingGaleItem.Mode.FLIGHT.getSerializedName(), Box.createVertical(Box.Alignment.RIGHT, new TextPane("FLIGHT"), rendingGaleFeatherPane))), (Object)((HUDPosition)((Object)Config.CLIENT.hudPositions.rendingGale.get()))));
        DynamicChargePane contentsPane = new DynamicChargePane(ModItems.VOID_TEAR.get(), VoidTearItem::getTearContents, is -> VoidTearItem.getTearContents(is).getCount());
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.VOID_TEAR.get(), (HUDPosition)((Object)Config.CLIENT.hudPositions.voidTear.get()), is -> ModItems.VOID_TEAR.get().getMode((ItemStack)is).getSerializedName(), Map.of(VoidTearItem.Mode.FULL_INVENTORY.getSerializedName(), Box.createVertical(Box.Alignment.RIGHT, new TextPane(Language.getInstance().getOrDefault(VOID_TEAR_MODE_TRANSLATION + VoidTearItem.Mode.FULL_INVENTORY.getSerializedName().toLowerCase())), contentsPane), VoidTearItem.Mode.NO_REFILL.getSerializedName(), Box.createVertical(Box.Alignment.RIGHT, new TextPane(Language.getInstance().getOrDefault(VOID_TEAR_MODE_TRANSLATION + VoidTearItem.Mode.NO_REFILL.getSerializedName().toLowerCase())), contentsPane), VoidTearItem.Mode.ONE_STACK.getSerializedName(), Box.createVertical(Box.Alignment.RIGHT, new TextPane(Language.getInstance().getOrDefault(VOID_TEAR_MODE_TRANSLATION + VoidTearItem.Mode.ONE_STACK.getSerializedName().toLowerCase())), contentsPane))){

            @Override
            public boolean shouldRender() {
                LocalPlayer player = Minecraft.getInstance().player;
                return player != null && !ModItems.VOID_TEAR.get().isEmpty(InventoryHelper.getCorrectItemFromEitherHand((Player)player, ModItems.VOID_TEAR.get()));
            }
        }, (Object)((HUDPosition)((Object)Config.CLIENT.hudPositions.voidTear.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.HARVEST_ROD.get(), (HUDPosition)((Object)Config.CLIENT.hudPositions.harvestRod.get()), is -> ModItems.HARVEST_ROD.get().getMode((ItemStack)is).getSerializedName(), Map.of(HarvestRodItem.Mode.BONE_MEAL.getSerializedName(), new ChargePane(ModItems.HARVEST_ROD.get(), new ItemStack((ItemLike)Items.BONE_MEAL), is -> ModItems.HARVEST_ROD.get().getBoneMealCount((ItemStack)is)), HarvestRodItem.Mode.HOE.getSerializedName(), new ItemStackPane(Items.WOODEN_HOE), "dynamic", new DynamicChargePane(ModItems.HARVEST_ROD.get(), is -> ModItems.HARVEST_ROD.get().getCurrentPlantable((ItemStack)is), is -> ModItems.HARVEST_ROD.get().getPlantableQuantity((ItemStack)is, ModItems.HARVEST_ROD.get().getCurrentPlantableSlot((ItemStack)is))))), (Object)((HUDPosition)((Object)Config.CLIENT.hudPositions.harvestRod.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.SOJOURNER_STAFF.get(), (HUDPosition)((Object)Config.CLIENT.hudPositions.sojournerStaff.get()), is -> "dynamic", Map.of("dynamic", new DynamicChargePane(ModItems.SOJOURNER_STAFF.get(), stack -> {
            ItemStack currentTorch = ModItems.SOJOURNER_STAFF.get().getCurrentTorch((ItemStack)stack);
            return currentTorch.isEmpty() ? new ItemStack((ItemLike)Items.TORCH) : currentTorch;
        }, ModItems.SOJOURNER_STAFF.get()::getTorchCount))), (Object)((HUDPosition)((Object)Config.CLIENT.hudPositions.sojournerStaff.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new HeroMedallionPane(), (Object)((HUDPosition)((Object)Config.CLIENT.hudPositions.heroMedallion.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)Box.createVertical(Box.Alignment.RIGHT, new HandgunPane(InteractionHand.OFF_HAND), new HandgunPane(InteractionHand.MAIN_HAND)), (Object)((HUDPosition)((Object)Config.CLIENT.hudPositions.handgun.get()))));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new CharmPane(), (Object)((HUDPosition)((Object)Config.CLIENT.hudPositions.mobCharm.get()))));
    }

    private static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(ModBlocks.APOTHECARY_MORTAR_TILE_TYPE.get(), context1 -> new ApothecaryMortarRenderer());
        event.registerBlockEntityRenderer(ModBlocks.PEDESTAL_TILE_TYPE.get(), context -> new PedestalRenderer());
        event.registerBlockEntityRenderer(ModBlocks.PASSIVE_PEDESTAL_TILE_TYPE.get(), context -> new PassivePedestalRenderer());
        event.registerEntityRenderer(ModEntities.LYSSA_HOOK.get(), FishingHookRenderer::new);
        event.registerEntityRenderer(ModEntities.BLAZE_SHOT.get(), context -> new ShotRenderer(context, ClientReference.BLAZE));
        event.registerEntityRenderer(ModEntities.BUSTER_SHOT.get(), context -> new ShotRenderer(context, ClientReference.BUSTER));
        event.registerEntityRenderer(ModEntities.CONCUSSIVE_SHOT.get(), context -> new ShotRenderer(context, ClientReference.CONCUSSIVE));
        event.registerEntityRenderer(ModEntities.ENDER_SHOT.get(), context -> new ShotRenderer(context, ClientReference.ENDER));
        event.registerEntityRenderer(ModEntities.EXORCISM_SHOT.get(), context -> new ShotRenderer(context, ClientReference.EXORCISM));
        event.registerEntityRenderer(ModEntities.NEUTRAL_SHOT.get(), context -> new ShotRenderer(context, ClientReference.NEUTRAL));
        event.registerEntityRenderer(ModEntities.SEEKER_SHOT.get(), context -> new ShotRenderer(context, ClientReference.SEEKER));
        event.registerEntityRenderer(ModEntities.SAND_SHOT.get(), context -> new ShotRenderer(context, ClientReference.SAND));
        event.registerEntityRenderer(ModEntities.STORM_SHOT.get(), context -> new ShotRenderer(context, ClientReference.STORM));
        event.registerEntityRenderer(ModEntities.TIPPED_ARROW.get(), TippedArrowRenderer::new);
        event.registerEntityRenderer(ModEntities.GLOWING_WATER.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(ModEntities.APHRODITE_POTION.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(ModEntities.FERTILE_POTION.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(ModEntities.HOLY_HAND_GRENADE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(ModEntities.KRAKEN_SLIME.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(ModEntities.SPECIAL_SNOWBALL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(ModEntities.ENDER_STAFF_PROJECTILE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(ModEntities.THROWN_POTION.get(), ThrownItemRenderer::new);
    }

    private static void registerConditionalItemModelProperties(RegisterConditionalItemModelPropertyEvent event) {
        event.register(Reliquary.getRL("lyssa_rod_cast"), LyssaRodCast.MAP_CODEC);
        event.register(Reliquary.getRL("infernal_tear_empty"), InfernalTearEmpty.MAP_CODEC);
    }

    private static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(FORTUNE_COIN_TOGGLE_KEYBIND);
    }

    private static void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            PedestalClientRegistry.registerItemRenderer(FishingRodItem.class, PedestalFishHookRenderer::new);
            PedestalClientRegistry.registerItemRenderer(RodOfLyssaItem.class, PedestalFishHookRenderer::new);
            NeoForge.EVENT_BUS.addListener(FortuneCoinToggler::handleKeyInputEvent);
        });
    }

    private static void registerWitchHatClientExtension(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){
            private WitchHatModel hatModel = null;

            public Model getHumanoidArmorModel(ItemStack itemStack, EquipmentClientInfo.LayerType layerType, Model original) {
                if (this.hatModel == null) {
                    EntityModelSet entityModels = Minecraft.getInstance().getEntityModels();
                    this.hatModel = new WitchHatModel(entityModels.bakeLayer(WITCH_HAT_LAYER));
                }
                return this.hatModel;
            }
        }, new Item[]{ModItems.WITCH_HAT.get()});
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final ResourceLocation XP_STILL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"reliquary", (String)"block/xp_still");
            private static final ResourceLocation XP_FLOWING_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"reliquary", (String)"block/xp_flowing");

            public ResourceLocation getStillTexture() {
                return XP_STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return XP_FLOWING_TEXTURE;
            }
        }, new FluidType[]{ModFluids.EXPERIENCE_FLUID_TYPE.get()});
    }
}

