/*
 * Decompiled with CFR 0.152.
 */
package reliquary.init;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import reliquary.block.AlkahestryAltarBlock;
import reliquary.block.ApothecaryCauldronBlock;
import reliquary.block.ApothecaryMortarBlock;
import reliquary.block.FertileLilyPadBlock;
import reliquary.block.InterdictionTorchBlock;
import reliquary.block.PassivePedestalBlock;
import reliquary.block.PedestalBlock;
import reliquary.block.WallInterdictionTorchBlock;
import reliquary.block.WraithNodeBlock;
import reliquary.block.tile.AlkahestryAltarBlockEntity;
import reliquary.block.tile.ApothecaryCauldronBlockEntity;
import reliquary.block.tile.ApothecaryMortarBlockEntity;
import reliquary.block.tile.PassivePedestalBlockEntity;
import reliquary.block.tile.PedestalBlockEntity;
import reliquary.item.block.BlockItemBase;
import reliquary.item.block.FertileLilyPadItem;
import reliquary.item.block.InterdictionTorchItem;

public class ModBlocks {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"reliquary");
    private static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"reliquary");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"reliquary");
    private static final String ALKAHESTRY_ALTAR_REGISTRY_NAME = "alkahestry_altar";
    private static final String INTERDICTION_TORCH_REGISTRY_NAME = "interdiction_torch";
    private static final String APOTHECARY_CAULDRON_REGISTRY_NAME = "apothecary_cauldron";
    private static final String APOTHECARY_MORTAR_REGISTRY_NAME = "apothecary_mortar";
    private static final String FERTILE_LILY_PAD_REGISTRY_NAME = "fertile_lily_pad";
    private static final String WRAITH_NODE_REGISTRY_NAME = "wraith_node";
    public static final Supplier<AlkahestryAltarBlock> ALKAHESTRY_ALTAR = BLOCKS.registerBlock("alkahestry_altar", AlkahestryAltarBlock::new);
    public static final Supplier<ApothecaryCauldronBlock> APOTHECARY_CAULDRON = BLOCKS.registerBlock("apothecary_cauldron", ApothecaryCauldronBlock::new);
    public static final Supplier<ApothecaryMortarBlock> APOTHECARY_MORTAR = BLOCKS.registerBlock("apothecary_mortar", ApothecaryMortarBlock::new);
    public static final Supplier<FertileLilyPadBlock> FERTILE_LILY_PAD = BLOCKS.registerBlock("fertile_lily_pad", FertileLilyPadBlock::new);
    public static final Supplier<InterdictionTorchBlock> INTERDICTION_TORCH = BLOCKS.registerBlock("interdiction_torch", InterdictionTorchBlock::new);
    public static final Supplier<WallInterdictionTorchBlock> WALL_INTERDICTION_TORCH = BLOCKS.registerBlock("wall_interdiction_torch", WallInterdictionTorchBlock::new);
    public static final Supplier<WraithNodeBlock> WRAITH_NODE = BLOCKS.registerBlock("wraith_node", WraithNodeBlock::new);
    public static final Map<DyeColor, Supplier<PassivePedestalBlock>> PASSIVE_PEDESTALS;
    public static final Map<DyeColor, Supplier<PedestalBlock>> PEDESTALS;
    public static final Supplier<BlockEntityType<AlkahestryAltarBlockEntity>> ALKAHESTRY_ALTAR_TILE_TYPE;
    public static final Supplier<BlockEntityType<PedestalBlockEntity>> PEDESTAL_TILE_TYPE;
    public static final Supplier<BlockEntityType<PassivePedestalBlockEntity>> PASSIVE_PEDESTAL_TILE_TYPE;
    public static final Supplier<BlockEntityType<ApothecaryCauldronBlockEntity>> APOTHECARY_CAULDRON_TILE_TYPE;
    public static final Supplier<BlockEntityType<ApothecaryMortarBlockEntity>> APOTHECARY_MORTAR_TILE_TYPE;
    public static final Supplier<BlockItemBase> ALKAHESTRY_ALTAR_ITEM;
    public static final Supplier<BlockItemBase> APOTHECARY_CAULDRON_ITEM;
    public static final Supplier<BlockItemBase> APOTHECARY_MORTAR_ITEM;
    public static final Supplier<BlockItemBase> FERTILE_LILY_PAD_ITEM;
    public static final Supplier<BlockItemBase> WRAITH_NODE_ITEM;
    public static final Supplier<InterdictionTorchItem> INTERDICTION_TORCH_ITEM;
    public static final Map<DyeColor, Supplier<BlockItem>> PEDESTAL_ITEMS;
    public static final Map<DyeColor, Supplier<BlockItem>> PASSIVE_PEDESTAL_ITEMS;
    private static final String BLOCK_PREFIX = "block.";

    private ModBlocks() {
    }

    public static void registerListeners(IEventBus modBus) {
        ITEMS.register(modBus);
        BLOCKS.register(modBus);
        BLOCK_ENTITY_TYPES.register(modBus);
        modBus.addListener(ModBlocks::registerCapabilities);
    }

    private static <T extends BlockEntity> BlockEntityType<T> getBlockEntityType(BlockEntityType.BlockEntitySupplier<T> tileFactory, Block ... validBlocks) {
        return new BlockEntityType(tileFactory, validBlocks);
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, APOTHECARY_MORTAR_TILE_TYPE.get(), (mortar, direction) -> mortar.getItems());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, PASSIVE_PEDESTAL_TILE_TYPE.get(), (pedestal, direction) -> pedestal.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, PEDESTAL_TILE_TYPE.get(), (pedestal, direction) -> pedestal.getItemHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, PEDESTAL_TILE_TYPE.get(), (pedestal, direction) -> pedestal.getFluidHandler());
    }

    static {
        ImmutableMap.Builder passiveBuilder = ImmutableMap.builder();
        ImmutableMap.Builder activeBuilder = ImmutableMap.builder();
        for (DyeColor color : DyeColor.values()) {
            passiveBuilder.put((Object)color, (Object)BLOCKS.registerBlock("pedestals/passive/" + color.getName() + "_passive_pedestal", properties -> new PassivePedestalBlock(properties.overrideDescription("block.reliquary.passive_pedestal"))));
            activeBuilder.put((Object)color, (Object)BLOCKS.registerBlock("pedestals/" + color.getName() + "_pedestal", properties -> new PedestalBlock(properties.overrideDescription("block.reliquary.pedestal"))));
        }
        PASSIVE_PEDESTALS = passiveBuilder.build();
        PEDESTALS = activeBuilder.build();
        ALKAHESTRY_ALTAR_TILE_TYPE = BLOCK_ENTITY_TYPES.register(ALKAHESTRY_ALTAR_REGISTRY_NAME, () -> ModBlocks.getBlockEntityType(AlkahestryAltarBlockEntity::new, ALKAHESTRY_ALTAR.get()));
        PEDESTAL_TILE_TYPE = BLOCK_ENTITY_TYPES.register("pedestal", () -> ModBlocks.getBlockEntityType(PedestalBlockEntity::new, (Block[])PEDESTALS.values().stream().map(Supplier::get).toArray(PedestalBlock[]::new)));
        PASSIVE_PEDESTAL_TILE_TYPE = BLOCK_ENTITY_TYPES.register("passive_pedestal", () -> ModBlocks.getBlockEntityType(PassivePedestalBlockEntity::new, (Block[])PASSIVE_PEDESTALS.values().stream().map(Supplier::get).toArray(PassivePedestalBlock[]::new)));
        APOTHECARY_CAULDRON_TILE_TYPE = BLOCK_ENTITY_TYPES.register(APOTHECARY_CAULDRON_REGISTRY_NAME, () -> ModBlocks.getBlockEntityType(ApothecaryCauldronBlockEntity::new, APOTHECARY_CAULDRON.get()));
        APOTHECARY_MORTAR_TILE_TYPE = BLOCK_ENTITY_TYPES.register(APOTHECARY_MORTAR_REGISTRY_NAME, () -> ModBlocks.getBlockEntityType(ApothecaryMortarBlockEntity::new, APOTHECARY_MORTAR.get()));
        ALKAHESTRY_ALTAR_ITEM = ITEMS.registerItem(ALKAHESTRY_ALTAR_REGISTRY_NAME, properties -> new BlockItemBase(ALKAHESTRY_ALTAR.get(), (Item.Properties)properties));
        APOTHECARY_CAULDRON_ITEM = ITEMS.registerItem(APOTHECARY_CAULDRON_REGISTRY_NAME, properties -> new BlockItemBase(APOTHECARY_CAULDRON.get(), (Item.Properties)properties));
        APOTHECARY_MORTAR_ITEM = ITEMS.registerItem(APOTHECARY_MORTAR_REGISTRY_NAME, properties -> new BlockItemBase(APOTHECARY_MORTAR.get(), (Item.Properties)properties));
        FERTILE_LILY_PAD_ITEM = ITEMS.registerItem(FERTILE_LILY_PAD_REGISTRY_NAME, FertileLilyPadItem::new);
        WRAITH_NODE_ITEM = ITEMS.registerItem(WRAITH_NODE_REGISTRY_NAME, properties -> new BlockItemBase(WRAITH_NODE.get(), (Item.Properties)properties));
        INTERDICTION_TORCH_ITEM = ITEMS.registerItem(INTERDICTION_TORCH_REGISTRY_NAME, InterdictionTorchItem::new);
        passiveBuilder = ImmutableMap.builder();
        activeBuilder = ImmutableMap.builder();
        for (DyeColor color : DyeColor.values()) {
            passiveBuilder.put((Object)color, (Object)ITEMS.registerItem("pedestals/passive/" + color.getName() + "_passive_pedestal", properties -> new BlockItemBase(PASSIVE_PEDESTALS.get(color).get(), properties.overrideDescription("block.reliquary.passive_pedestal"))));
            activeBuilder.put((Object)color, (Object)ITEMS.registerItem("pedestals/" + color.getName() + "_pedestal", properties -> new BlockItemBase(PEDESTALS.get(color).get(), properties.overrideDescription("block.reliquary.pedestal"))));
        }
        PASSIVE_PEDESTAL_ITEMS = passiveBuilder.build();
        PEDESTAL_ITEMS = activeBuilder.build();
    }
}

