/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.function.Consumer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import reliquary.item.ItemBase;
import reliquary.item.util.IPotionItem;
import reliquary.reference.Config;
import reliquary.util.potions.PotionEssence;
import reliquary.util.potions.PotionHelper;
import reliquary.util.potions.PotionMap;

public class BulletItem
extends ItemBase
implements IPotionItem {
    private final boolean hasTooltip;
    private final boolean addPotionBulletsInItemGroup;
    private final int color;

    public BulletItem(boolean hasTooltip, boolean addPotionBulletsInItemGroup, int color, Item.Properties properties) {
        super(properties.setNoCombineRepair());
        this.hasTooltip = hasTooltip;
        this.addPotionBulletsInItemGroup = addPotionBulletsInItemGroup;
        this.color = color;
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        if (Boolean.TRUE.equals(Config.COMMON.disable.disableHandgun.get())) {
            return;
        }
        itemConsumer.accept(new ItemStack((ItemLike)this));
        if (!this.addPotionBulletsInItemGroup || Boolean.TRUE.equals(Config.COMMON.disable.disablePotions.get())) {
            return;
        }
        for (PotionEssence essence : PotionMap.uniquePotionEssences) {
            ItemStack bullet = new ItemStack((ItemLike)this);
            PotionHelper.addPotionContentsToStack(bullet, PotionHelper.changePotionEffectsDuration(essence.getPotionContents(), 0.2f));
            itemConsumer.accept(bullet);
        }
    }

    @Override
    public PotionContents getPotionContents(ItemStack stack) {
        return (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
    }

    public int getColor() {
        return this.color;
    }
}

