/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.SpecialPlantable;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import reliquary.block.FertileLilyPadBlock;
import reliquary.entity.ReliquaryFakePlayer;
import reliquary.init.ModDataComponents;
import reliquary.init.ModItems;
import reliquary.item.ChargeableItem;
import reliquary.item.util.HarvestRodCache;
import reliquary.item.util.IScrollableItem;
import reliquary.reference.Config;
import reliquary.util.FakePlayerFactory;
import reliquary.util.InventoryHelper;
import reliquary.util.ItemHelper;
import reliquary.util.RandHelper;
import reliquary.util.TooltipBuilder;

public class HarvestRodItem
extends ChargeableItem
implements IScrollableItem {
    private static final int AOE_START_COOLDOWN = 10;
    public static final int BONEMEAL_SLOT = 0;

    public HarvestRodItem(Item.Properties properties) {
        super(properties.stacksTo(1).setNoCombineRepair());
    }

    @Override
    public MutableComponent getName(ItemStack stack) {
        return super.getName(stack).withStyle(ChatFormatting.DARK_GREEN);
    }

    @Override
    protected void addMoreInformation(ItemStack rod, @Nullable HolderLookup.Provider registries, TooltipBuilder tooltipBuilder) {
        tooltipBuilder.charge(this, ".tooltip2", this.getBoneMealCount(rod));
        for (int slot = 1; slot < this.getCountOfPlantables(rod); ++slot) {
            ItemStack plantable = this.getPlantableInSlot(rod, slot);
            tooltipBuilder.charge((Item)this, ".tooltip3", plantable.getItem().getName(plantable).getString(), this.getPlantableQuantity(rod, slot));
        }
        if (this.isEnabled(rod)) {
            tooltipBuilder.absorbActive(new ItemStack((ItemLike)Items.BONE_MEAL).getHoverName().getString());
        } else {
            tooltipBuilder.absorb();
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BLOCK;
    }

    private int getBonemealLimit() {
        return (Integer)Config.COMMON.items.harvestRod.boneMealLimit.get();
    }

    private int getBonemealWorth() {
        return (Integer)Config.COMMON.items.harvestRod.boneMealWorth.get();
    }

    public int getBonemealCost() {
        return (Integer)Config.COMMON.items.harvestRod.boneMealCost.get();
    }

    public int getLuckRolls() {
        return (Integer)Config.COMMON.items.harvestRod.boneMealLuckRolls.get();
    }

    public int getLuckPercent() {
        return (Integer)Config.COMMON.items.harvestRod.boneMealLuckPercentChance.get();
    }

    private int getBreakRadius() {
        return (Integer)Config.COMMON.items.harvestRod.aoeRadius.get();
    }

    @Override
    protected boolean isItemValidForContainerSlot(ItemStack containerStack, int slot, ItemStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        if (slot == 0) {
            return stack.is(Items.BONE_MEAL);
        }
        return HarvestRodItem.isPlantable(stack);
    }

    @Override
    protected int getContainerSlotLimit(int slot) {
        if (slot == 0) {
            return this.getBonemealLimit();
        }
        return (Integer)Config.COMMON.items.harvestRod.maxCapacityPerPlantable.get();
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        Player player;
        if (level.isClientSide || !(entity instanceof Player) || (player = (Player)entity).isSpectator() || level.getGameTime() % 10L != 0L) {
            return;
        }
        if (this.isEnabled(stack)) {
            int currentCharge = this.getBoneMealCount(stack);
            this.consumeAndCharge(stack, 0, player, this.getBonemealLimit() - currentCharge, 1, 16);
            this.consumePlantables(stack, player);
        }
    }

    @Override
    public void addStoredCharge(ItemStack containerStack, int slot, int chargeToAdd, @Nullable ItemStack chargeStack) {
        if (slot == 0) {
            int currentCharge = this.getBoneMealCount(containerStack);
            this.setBoneMealCount(containerStack, Math.min(this.getBonemealLimit(), currentCharge + chargeToAdd));
        } else {
            this.incrementPlantable(containerStack, new ItemStack((ItemLike)Items.BONE_MEAL), chargeToAdd);
        }
    }

    @Override
    protected void extractStoredCharge(ItemStack harvestRod, int slot, int chargeToExtract) {
        if (slot == 0) {
            super.extractStoredCharge(harvestRod, slot, chargeToExtract);
        } else {
            this.runOnHandler(harvestRod, h -> h.extractItem(slot, chargeToExtract, false));
        }
    }

    @Override
    public int getStoredCharge(ItemStack containerStack, int slot) {
        if (slot == 0) {
            return this.getBoneMealCount(containerStack);
        }
        return this.getPlantableQuantity(containerStack, (byte)slot);
    }

    @Override
    protected int getSlotWorth(int slot) {
        return slot == 0 ? this.getBonemealWorth() : 1;
    }

    @Override
    protected boolean removeSlotWhenEmpty(int slot) {
        return slot != 0;
    }

    @Override
    protected void removeSlot(ItemStack harvestRod, int slot) {
        this.runOnHandler(harvestRod, h -> h.removeSlot(slot));
        this.shiftModeOnEmptyPlantable(harvestRod, (byte)slot);
    }

    private void consumePlantables(ItemStack harvestRod, Player player) {
        int leftToInsert = 16;
        for (int slot = 0; slot < player.getInventory().getNonEquipmentItems().size(); ++slot) {
            ItemStack currentStack = (ItemStack)player.getInventory().getNonEquipmentItems().get(slot);
            if (!HarvestRodItem.isPlantable(currentStack)) continue;
            int countInserted = this.incrementPlantable(harvestRod, currentStack, leftToInsert);
            currentStack.shrink(countInserted);
            player.getInventory().getNonEquipmentItems().set(slot, (Object)(currentStack.isEmpty() ? ItemStack.EMPTY : currentStack));
            if ((leftToInsert -= countInserted) == 0) break;
        }
    }

    public static boolean isPlantable(ItemStack currentStack) {
        return currentStack.is(Tags.Items.SEEDS) || currentStack.is(ItemTags.VILLAGER_PLANTABLE_SEEDS) || currentStack.getItem() instanceof SpecialPlantable;
    }

    public boolean canDestroyBlock(ItemStack stack, BlockState state, Level level, BlockPos pos, LivingEntity livingEntity) {
        if (livingEntity.level().isClientSide) {
            return true;
        }
        boolean brokenBlock = false;
        BlockState blockState = livingEntity.level().getBlockState(pos);
        if (HarvestRodItem.canBreakBlock(blockState)) {
            for (int xOff = -this.getBreakRadius(); xOff <= this.getBreakRadius(); ++xOff) {
                for (int yOff = -this.getBreakRadius(); yOff <= this.getBreakRadius(); ++yOff) {
                    for (int zOff = -this.getBreakRadius(); zOff <= this.getBreakRadius(); ++zOff) {
                        brokenBlock |= this.doHarvestBlockBreak(blockState.getBlock(), livingEntity.getMainHandItem(), pos, livingEntity, xOff, yOff, zOff);
                    }
                }
            }
        }
        return !brokenBlock;
    }

    private boolean doHarvestBlockBreak(Block initialBlock, ItemStack stack, BlockPos pos, LivingEntity livingEntity, int xOff, int yOff, int zOff) {
        pos = pos.offset(xOff, yOff, zOff);
        BlockState blockState = livingEntity.level().getBlockState(pos);
        Block block = blockState.getBlock();
        if ((initialBlock == Blocks.MELON || initialBlock == Blocks.PUMPKIN) && block != Blocks.MELON && block != Blocks.PUMPKIN) {
            return false;
        }
        if (!HarvestRodItem.canBreakBlock(blockState)) {
            return false;
        }
        if (block instanceof FertileLilyPadBlock) {
            return false;
        }
        if (livingEntity.level().isClientSide) {
            for (int particles = 0; particles <= 8; ++particles) {
                livingEntity.level().levelEvent((Entity)livingEntity, 2001, pos, Block.getId((BlockState)blockState));
            }
        } else {
            Level particles = livingEntity.level();
            if (particles instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)particles;
                List drops = Block.getDrops((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)livingEntity, (ItemStack)stack);
                for (ItemStack itemStack : drops) {
                    float f = 0.7f;
                    double d = (double)(serverLevel.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d1 = (double)(serverLevel.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d2 = (double)(serverLevel.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    ItemEntity entityitem = new ItemEntity(livingEntity.level(), (double)pos.getX() + d, (double)pos.getY() + d1, (double)pos.getZ() + d2, itemStack);
                    entityitem.setPickUpDelay(10);
                    livingEntity.level().addFreshEntity((Entity)entityitem);
                }
                livingEntity.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    player.awardStat(Stats.BLOCK_MINED.get((Object)blockState.getBlock()));
                    player.causeFoodExhaustion(0.01f);
                }
            }
        }
        return true;
    }

    private static boolean canBreakBlock(BlockState blockState) {
        Block block = blockState.getBlock();
        return blockState.is(BlockTags.CROPS) || block instanceof BushBlock || block == Blocks.MELON || block == Blocks.PUMPKIN;
    }

    private void boneMealBlock(ItemStack stack, Player player, Level level, BlockPos pos) {
        ItemStack fakeItemStack = new ItemStack((ItemLike)Items.BONE_MEAL);
        boolean usedRod = false;
        for (int repeatedUses = 0; repeatedUses <= this.getLuckRolls(); ++repeatedUses) {
            if (repeatedUses != 0 && level.random.nextInt(100) > this.getLuckPercent() || !BoneMealItem.applyBonemeal((ItemStack)fakeItemStack, (Level)level, (BlockPos)pos, (Player)player)) continue;
            if (!usedRod) {
                usedRod = true;
            }
            player.level().levelEvent(1505, pos, 15);
            player.level().playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.NEUTRAL, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.level().random) * 0.7f + 1.2f));
        }
        if (usedRod && !player.isCreative()) {
            this.useCharge(stack, 0, this.getBonemealCost());
        }
    }

    public int getBoneMealCount(ItemStack stack) {
        return this.getFromHandler(stack, handler -> handler.getSlots() > 0 ? handler.getCountInSlot(0) : 0);
    }

    public void setBoneMealCount(ItemStack harvestRod, int boneMealCount) {
        this.runOnHandler(harvestRod, h -> h.setStackInSlot(0, boneMealCount == 0 ? ItemStack.EMPTY : new ItemStack((ItemLike)Items.BONE_MEAL, boneMealCount)));
    }

    private int incrementPlantable(ItemStack harvestRod, ItemStack plantable, int maxCount) {
        return this.getFromHandler(harvestRod, h -> {
            ItemStack plantableCopy = plantable.copy();
            plantableCopy.setCount(Math.min(maxCount, plantableCopy.getCount()));
            ItemStack remaining = h.insertItemOrAddIntoNewSlotIfNoStackMatches(plantableCopy);
            return plantableCopy.getCount() - remaining.getCount();
        });
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (player.isShiftKeyDown()) {
            return super.use(level, player, hand);
        }
        player.startUsingItem(hand);
        return InteractionResult.SUCCESS;
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 300;
    }

    public boolean releaseUsing(ItemStack harvestRod, Level level, LivingEntity entity, int timeLeft) {
        if (entity.level().isClientSide || !(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        BlockHitResult result = HarvestRodItem.getPlayerPOVHitResult((Level)player.level(), (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (result.getType() == HitResult.Type.BLOCK) {
            HarvestRodCache harvestRodCache = (HarvestRodCache)harvestRod.getCapability(ModItems.HARVEST_ROD_CACHE_CAPABILITY);
            if (harvestRodCache == null) {
                return false;
            }
            harvestRodCache.reset();
            BlockPos pos = result.getBlockPos();
            switch (this.getMode(harvestRod).ordinal()) {
                case 0: {
                    if (this.getBoneMealCount(harvestRod) < this.getBonemealCost() && !player.isCreative()) break;
                    this.boneMealBlock(harvestRod, player, level, pos);
                    break;
                }
                case 1: {
                    if (this.getPlantableQuantity(harvestRod, this.getCurrentPlantableSlot(harvestRod)) <= 0 && !player.isCreative()) break;
                    this.plantItem(harvestRod, player, pos, player.getUsedItemHand());
                    break;
                }
                case 2: {
                    this.hoeLand(level, pos);
                    return false;
                }
            }
        } else {
            this.removeStackFromCurrent(harvestRod, player);
        }
        return true;
    }

    private void hoeLand(Level level, BlockPos pos) {
        ItemStack fakeHoe = new ItemStack((ItemLike)Items.WOODEN_HOE);
        ReliquaryFakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)level);
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, fakeHoe);
        if (Items.WOODEN_HOE.useOn(ItemHelper.getItemUseContext(pos, (Player)fakePlayer)) == InteractionResult.SUCCESS) {
            level.playSound(null, pos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void removeStackFromCurrent(ItemStack stack, Player player) {
        if (this.getMode(stack) == Mode.BONE_MEAL && this.getBoneMealCount(stack) > 0) {
            ItemStack boneMealStack = new ItemStack((ItemLike)Items.BONE_MEAL);
            int numberToAdd = Math.min(boneMealStack.getMaxStackSize(), this.getBoneMealCount(stack));
            IItemHandler playerInventory = InventoryHelper.getMainInventoryItemHandlerFrom(player);
            int numberAdded = InventoryHelper.tryToAddToInventory(boneMealStack, playerInventory, numberToAdd);
            this.setBoneMealCount(stack, this.getBoneMealCount(stack) - numberAdded);
        } else if (this.getMode(stack) == Mode.PLANTABLE) {
            byte plantableSlot = this.getCurrentPlantableSlot(stack);
            ItemStack plantableStack = this.getCurrentPlantable(stack);
            int plantableQuantity = this.getPlantableQuantity(stack, plantableSlot);
            int numberToAdd = Math.min(plantableStack.getMaxStackSize(), plantableQuantity);
            IItemHandler playerInventory = InventoryHelper.getMainInventoryItemHandlerFrom(player);
            int numberAdded = InventoryHelper.tryToAddToInventory(plantableStack, playerInventory, numberToAdd);
            this.extractStoredCharge(stack, plantableSlot, numberAdded);
            if (this.getPlantableQuantity(stack, plantableSlot) == 0) {
                this.removeSlot(stack, plantableSlot);
                this.shiftModeOnEmptyPlantable(stack, plantableSlot);
            }
        }
    }

    private void shiftModeOnEmptyPlantable(ItemStack harvestRod, byte plantableSlot) {
        if (plantableSlot > 0) {
            this.setCurrentPlantableSlot(harvestRod, (byte)(plantableSlot - 1));
        }
        this.cycleMode(harvestRod, true);
    }

    private void plantItem(ItemStack harvestRod, Player player, BlockPos pos, InteractionHand hand) {
        byte plantableSlot = this.getCurrentPlantableSlot(harvestRod);
        ItemStack fakePlantableStack = this.getCurrentPlantable(harvestRod).copy();
        fakePlantableStack.setCount(1);
        ReliquaryFakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)player.level());
        fakePlayer.setItemInHand(hand, fakePlantableStack);
        if (fakePlantableStack.useOn(ItemHelper.getItemUseContext(pos, (Player)fakePlayer)).consumesAction()) {
            player.level().playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.level().random) * 0.7f + 1.2f));
            if (!player.isCreative()) {
                this.useCharge(harvestRod, plantableSlot, 1);
            }
        }
    }

    public ItemStack getCurrentPlantable(ItemStack harvestRod) {
        byte currentSlot = this.getCurrentPlantableSlot(harvestRod);
        return this.getPlantableInSlot(harvestRod, currentSlot);
    }

    public ItemStack getPlantableInSlot(ItemStack harvestRod, int slot) {
        if (slot <= 0) {
            return ItemStack.EMPTY;
        }
        return this.getFromHandler(harvestRod, h -> h.getSlots() > slot ? h.getStackInSlot(slot) : ItemStack.EMPTY);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack harvestRod, int remainingUseDuration) {
        HarvestRodCache harvestRodCache;
        BlockHitResult result;
        if (livingEntity.level().isClientSide || !(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (this.isCoolDownOver(harvestRod, remainingUseDuration, livingEntity) && (result = HarvestRodItem.getPlayerPOVHitResult((Level)player.level(), (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY)).getType() == HitResult.Type.BLOCK && (harvestRodCache = (HarvestRodCache)harvestRod.getCapability(ModItems.HARVEST_ROD_CACHE_CAPABILITY)) != null) {
            this.doAction(harvestRod, player, level, harvestRodCache, result.getBlockPos());
        }
    }

    private void doAction(ItemStack harvestRod, Player player, Level level, HarvestRodCache cache, BlockPos pos) {
        switch (this.getMode(harvestRod).ordinal()) {
            case 0: {
                if (this.getBoneMealCount(harvestRod) < this.getBonemealCost() && !player.isCreative()) break;
                this.getNextBlockToBoneMeal(level, cache, pos, (Integer)Config.COMMON.items.harvestRod.aoeRadius.get()).ifPresent(blockToBoneMeal -> this.boneMealBlock(harvestRod, player, level, (BlockPos)blockToBoneMeal));
                break;
            }
            case 1: {
                if (this.getPlantableQuantity(harvestRod, this.getCurrentPlantableSlot(harvestRod)) < 1 && !player.isCreative()) break;
                this.getNextBlockToPlantOn(level, cache, pos, (Integer)Config.COMMON.items.harvestRod.aoeRadius.get(), this.getCurrentPlantable(harvestRod)).ifPresent(blockToPlantOn -> this.plantItem(harvestRod, player, (BlockPos)blockToPlantOn, player.getUsedItemHand()));
                break;
            }
            case 2: {
                this.getNextBlockToHoe(level, cache, pos, (Integer)Config.COMMON.items.harvestRod.aoeRadius.get()).ifPresent(blockToHoe -> this.hoeLand(level, (BlockPos)blockToHoe));
                break;
            }
        }
    }

    private Optional<BlockPos> getNextBlockToHoe(Level level, HarvestRodCache cache, BlockPos pos, int range) {
        if (cache.isQueueEmpty() || !pos.equals((Object)cache.getStartBlockPos())) {
            this.fillQueue(cache, pos, range, currentPos -> {
                BlockState blockState = level.getBlockState(currentPos);
                Block block = blockState.getBlock();
                return level.isEmptyBlock(currentPos.above()) && (block == Blocks.GRASS_BLOCK || block == Blocks.DIRT_PATH || block == Blocks.DIRT || block == Blocks.COARSE_DIRT);
            });
        }
        return cache.getNextBlockInQueue();
    }

    private void fillQueue(HarvestRodCache cache, BlockPos pos, int range, Predicate<BlockPos> isValidBlock) {
        cache.setStartBlockPos(pos);
        cache.clearBlockQueue();
        BlockPos.betweenClosedStream((BlockPos)pos.offset(-range, -range, -range), (BlockPos)pos.offset(range, range, range)).forEach(currentPos -> {
            if (isValidBlock.test((BlockPos)currentPos)) {
                cache.addBlockToQueue(currentPos.immutable());
            }
        });
    }

    private Optional<BlockPos> getNextBlockToPlantOn(Level level, HarvestRodCache cache, BlockPos pos, int range, ItemStack plantable) {
        if (cache.isQueueEmpty() || !pos.equals((Object)cache.getStartBlockPos())) {
            this.fillQueueToPlant(level, cache, pos, range, plantable);
        }
        return cache.getNextBlockInQueue();
    }

    private void fillQueueToPlant(Level level, HarvestRodCache cache, BlockPos pos, int range, ItemStack plantable) {
        boolean checkerboard = false;
        boolean bothOddOrEven = false;
        if (plantable.getItem() == Items.PUMPKIN_SEEDS || plantable.getItem() == Items.MELON_SEEDS) {
            checkerboard = true;
            boolean xEven = pos.getX() % 2 == 0;
            boolean zEven = pos.getZ() % 2 == 0;
            bothOddOrEven = xEven == zEven;
        }
        boolean finalCheckerboard = checkerboard;
        boolean finalBothOddOrEven = bothOddOrEven;
        this.fillQueue(cache, pos, range, currentPos -> (!finalCheckerboard || finalBothOddOrEven == (currentPos.getX() % 2 == 0 == (currentPos.getZ() % 2 == 0))) && level.isEmptyBlock(currentPos.above()) && HarvestRodItem.canPlacePlantableAt(level, currentPos.above(), plantable));
    }

    public static boolean canPlacePlantableAt(Level level, BlockPos pos, ItemStack plantable) {
        BlockItem blockItem;
        SpecialPlantable specialPlantable;
        Item item = plantable.getItem();
        if (item instanceof SpecialPlantable && (specialPlantable = (SpecialPlantable)item).canPlacePlantAtPosition(plantable, (LevelReader)level, pos, null)) {
            return true;
        }
        item = plantable.getItem();
        return item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock().defaultBlockState().canSurvive((LevelReader)level, pos);
    }

    @Override
    public InteractionResult onMouseScrolled(ItemStack stack, Player player, double scrollDelta) {
        if (player.level().isClientSide) {
            return InteractionResult.PASS;
        }
        this.cycleMode(stack, scrollDelta > 0.0);
        return InteractionResult.SUCCESS;
    }

    private boolean isCoolDownOver(ItemStack stack, int count, LivingEntity livingEntity) {
        return this.getUseDuration(stack, livingEntity) - count >= 10 && (this.getUseDuration(stack, livingEntity) - count) % (Integer)Config.COMMON.items.harvestRod.aoeCooldown.get() == 0;
    }

    private Optional<BlockPos> getNextBlockToBoneMeal(Level level, HarvestRodCache cache, BlockPos pos, int range) {
        if (cache.isQueueEmpty() || !pos.equals((Object)cache.getStartBlockPos())) {
            this.fillQueue(cache, pos, range, currentPos -> {
                BonemealableBlock bonemealableBlock;
                BlockState blockState = level.getBlockState(currentPos);
                Block patt0$temp = blockState.getBlock();
                return patt0$temp instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)patt0$temp).isValidBonemealTarget((LevelReader)level, currentPos, blockState);
            });
        }
        return cache.getNextBlockInQueue();
    }

    private void cycleMode(ItemStack harvestRod, boolean next) {
        Mode currentMode = this.getMode(harvestRod);
        int plantableCount = this.getCountOfPlantables(harvestRod);
        if (next) {
            this.setNextMode(harvestRod, currentMode, plantableCount);
        } else {
            this.setPreviousMode(harvestRod, currentMode, plantableCount);
        }
    }

    private void setPreviousMode(ItemStack harvestRod, Mode currentMode, int plantableCount) {
        if (currentMode == Mode.PLANTABLE && this.getCurrentPlantableSlot(harvestRod) > 1) {
            this.setCurrentPlantableSlot(harvestRod, (byte)(this.getCurrentPlantableSlot(harvestRod) - 1));
            return;
        }
        Mode previousMode = currentMode.previous();
        if (previousMode == Mode.PLANTABLE) {
            if (plantableCount == 0) {
                previousMode = previousMode.previous();
            } else {
                this.setCurrentPlantableSlot(harvestRod, (byte)plantableCount);
            }
        }
        this.setMode(harvestRod, previousMode);
    }

    private void setNextMode(ItemStack harvestRod, Mode currentMode, int plantableCount) {
        if (currentMode == Mode.PLANTABLE && plantableCount > this.getCurrentPlantableSlot(harvestRod)) {
            this.setCurrentPlantableSlot(harvestRod, (byte)(this.getCurrentPlantableSlot(harvestRod) + 1));
            return;
        }
        Mode nextMode = currentMode.next();
        if (nextMode == Mode.PLANTABLE) {
            if (plantableCount == 0) {
                nextMode = nextMode.next();
            } else {
                this.setCurrentPlantableSlot(harvestRod, (byte)1);
            }
        }
        this.setMode(harvestRod, nextMode);
    }

    public int getCountOfPlantables(ItemStack harvestRod) {
        return this.getFromHandler(harvestRod, h -> Math.max(h.getSlots() - 1, 0));
    }

    public byte getCurrentPlantableSlot(ItemStack stack) {
        return (Byte)stack.getOrDefault(ModDataComponents.PLANTABLE_INDEX, (Object)-1);
    }

    private void setCurrentPlantableSlot(ItemStack stack, byte index) {
        stack.set(ModDataComponents.PLANTABLE_INDEX, (Object)index);
    }

    private void setMode(ItemStack stack, Mode mode) {
        stack.set(ModDataComponents.HARVEST_ROD_MODE, (Object)mode);
    }

    public Mode getMode(ItemStack stack) {
        return (Mode)((Object)stack.getOrDefault(ModDataComponents.HARVEST_ROD_MODE, (Object)Mode.BONE_MEAL));
    }

    public int getPlantableQuantity(ItemStack harvestRod, int slot) {
        if (slot <= 0) {
            return 0;
        }
        return this.getFromHandler(harvestRod, h -> h.getSlots() > slot ? h.getCountInSlot(slot) : 0);
    }

    public static enum Mode implements StringRepresentable
    {
        BONE_MEAL,
        PLANTABLE,
        HOE;

        public static final Codec<Mode> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Mode> STREAM_CODEC;
        private static final Mode[] VALUES;

        public String getSerializedName() {
            return this.name();
        }

        public Mode next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public Mode previous() {
            return VALUES[Math.floorMod(this.ordinal() - 1, VALUES.length)];
        }

        static {
            CODEC = StringRepresentable.fromEnum(Mode::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Mode.class);
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Mode value : Mode.values()) {
                builder.put((Object)value.getSerializedName(), (Object)value);
            }
            VALUES = Mode.values();
        }
    }
}

