/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import reliquary.handler.CommonEventHandler;
import reliquary.handler.HandlerPriority;
import reliquary.handler.IPlayerHurtHandler;
import reliquary.init.ModDataComponents;
import reliquary.init.ModItems;
import reliquary.item.ToggleableItem;
import reliquary.reference.Config;
import reliquary.util.InventoryHelper;
import reliquary.util.TooltipBuilder;

public class InfernalChaliceItem
extends ToggleableItem {
    public InfernalChaliceItem(Item.Properties properties) {
        super(properties.stacksTo(1).setNoCombineRepair());
        CommonEventHandler.registerPlayerHurtHandler(new IPlayerHurtHandler(this){

            @Override
            public boolean canApply(Player player, LivingIncomingDamageEvent event) {
                return event.getSource().is(DamageTypeTags.IS_FIRE) && player.getFoodData().getFoodLevel() > 0 && InventoryHelper.playerHasItem(player, ModItems.INFERNAL_CHALICE.get());
            }

            @Override
            public boolean apply(Player player, LivingIncomingDamageEvent event) {
                player.causeFoodExhaustion(event.getAmount() * ((float)((Integer)Config.COMMON.items.infernalChalice.hungerCostPercent.get()).intValue() / 100.0f));
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.HIGH;
            }
        });
    }

    @Override
    protected void addMoreInformation(ItemStack chalice, @Nullable HolderLookup.Provider registries, TooltipBuilder tooltipBuilder) {
        tooltipBuilder.charge(this, ".tooltip2", ((SimpleFluidContent)chalice.getOrDefault(ModDataComponents.FLUID_CONTENTS, (Object)SimpleFluidContent.EMPTY)).getAmount());
        if (this.isEnabled(chalice)) {
            tooltipBuilder.description("tooltip.reliquary.place", new Object[0]);
        } else {
            tooltipBuilder.description("tooltip.reliquary.drain", new Object[0]);
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            return super.use(level, player, hand);
        }
        BlockHitResult result = InfernalChaliceItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)(this.isEnabled(stack) ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (result.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        BlockPos pos = result.getBlockPos();
        if (!level.mayInteract((Entity)player, pos)) {
            return InteractionResult.PASS;
        }
        Direction face = result.getDirection();
        if (!player.mayUseItemAt(pos, face, stack)) {
            return InteractionResult.PASS;
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return InteractionResult.FAIL;
        }
        return this.interactWithFluidHandler(level, player, stack, pos, face, fluidHandler);
    }

    private InteractionResult interactWithFluidHandler(Level level, Player player, ItemStack stack, BlockPos pos, Direction face, IFluidHandlerItem fluidHandler) {
        BlockState blockState = level.getBlockState(pos);
        if (this.isEnabled(stack)) {
            if (blockState.getBlock() == Blocks.LAVA && (Integer)blockState.getValue((Property)LiquidBlock.LEVEL) == 0 && fluidHandler.fill(new FluidStack((Fluid)Fluids.LAVA, 1000), IFluidHandler.FluidAction.SIMULATE) == 1000) {
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                Fluids.LAVA.getPickupSound().ifPresent(soundEvent -> level.playSound((Entity)player, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f));
                fluidHandler.fill(new FluidStack((Fluid)Fluids.LAVA, 1000), IFluidHandler.FluidAction.EXECUTE);
                return InteractionResult.SUCCESS.heldItemTransformedTo(stack);
            }
        } else {
            BlockPos adjustedPos;
            FluidStack fluidDrained = fluidHandler.drain(new FluidStack((Fluid)Fluids.LAVA, 1000), IFluidHandler.FluidAction.SIMULATE);
            if ((player.isCreative() || fluidDrained.getAmount() == 1000) && this.tryPlaceContainedLiquid(player, level, adjustedPos = pos.relative(face)) && !player.isCreative()) {
                fluidHandler.drain(new FluidStack((Fluid)Fluids.LAVA, 1000), IFluidHandler.FluidAction.EXECUTE);
                return InteractionResult.SUCCESS.heldItemTransformedTo(stack);
            }
        }
        return InteractionResult.PASS;
    }

    private boolean tryPlaceContainedLiquid(Player player, Level level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        if (!blockState.canBeReplaced((Fluid)Fluids.LAVA)) {
            return false;
        }
        level.setBlock(pos, Blocks.LAVA.defaultBlockState(), 3);
        level.playSound((Entity)player, pos, SoundEvents.BUCKET_EMPTY_LAVA, SoundSource.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    public static int getFluidBucketAmount(ItemStack stack) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        return fluidHandler != null ? fluidHandler.getFluidInTank(0).getAmount() / 1000 : 0;
    }
}

