/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import reliquary.init.ModDataComponents;
import reliquary.item.ToggleableItem;
import reliquary.reference.Config;
import reliquary.util.InventoryHelper;
import reliquary.util.RegistryHelper;
import reliquary.util.TooltipBuilder;

public class InfernalTearItem
extends ToggleableItem {
    private static final int COOLDOWN = 4;
    private static final int NOTHING_FOUND_COOLDOWN = 20;

    public InfernalTearItem(Item.Properties properties) {
        super(properties.stacksTo(1).setNoCombineRepair().rarity(Rarity.EPIC));
    }

    @Override
    public MutableComponent getName(ItemStack stack) {
        return super.getName(stack).withStyle(ChatFormatting.RED);
    }

    public void inventoryTick(ItemStack tear, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        Player player;
        if (level.isClientSide || !(entity instanceof Player) || (player = (Player)entity).isSpectator() || level.getGameTime() % 4L != 0L || !this.isEnabled(tear) || this.isInCooldown(tear, (Level)level)) {
            return;
        }
        ItemStack tearStack = InfernalTearItem.getStackFromTear(tear);
        if (tearStack.isEmpty()) {
            this.resetTear(tear);
            return;
        }
        Optional<Integer> experience = Config.COMMON.items.infernalTear.getItemExperience(RegistryHelper.getItemRegistryName(tearStack.getItem()));
        if (experience.isEmpty()) {
            this.resetTear(tear);
            return;
        }
        int countConsumed = InventoryHelper.consumeItemStack(stack -> ItemStack.isSameItemSameComponents((ItemStack)tearStack, (ItemStack)stack), player, 4).getCount();
        if (countConsumed > 0) {
            player.giveExperiencePoints(experience.get() * countConsumed);
        } else {
            this.setCooldown(tear, (Level)level, 20);
        }
    }

    private void resetTear(ItemStack stack) {
        stack.remove(DataComponents.CONTAINER);
        stack.remove(ModDataComponents.ENABLED);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltip, flag);
        if (InfernalTearItem.getStackFromTear(stack).isEmpty()) {
            TooltipBuilder.of(tooltip, context).description("tooltip.reliquary.tear_empty", new Object[0]);
        }
    }

    @Override
    protected void addMoreInformation(ItemStack stack, @Nullable HolderLookup.Provider registries, TooltipBuilder tooltipBuilder) {
        ItemStack contents = InfernalTearItem.getStackFromTear(stack);
        String itemName = contents.getHoverName().getString();
        tooltipBuilder.data("tooltip.reliquary.tear", itemName);
        if (this.isEnabled(stack)) {
            tooltipBuilder.absorbActive(itemName);
        }
        tooltipBuilder.description("tooltip.reliquary.absorb", new Object[0]);
        tooltipBuilder.description(this, ".infernal_tear.absorb_unset", new Object[0]);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return !InfernalTearItem.getStackFromTear(stack).isEmpty();
    }

    public static ItemStack getStackFromTear(ItemStack tear) {
        ItemContainerContents contents = (ItemContainerContents)tear.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        return contents.getSlots() > 0 ? contents.getStackInSlot(0) : ItemStack.EMPTY;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        IItemHandler playerInventory;
        ItemStack returnStack;
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        InteractionResult actionResult = super.use(level, player, hand);
        ItemStack tear = player.getItemInHand(hand);
        if (player.isShiftKeyDown() && !this.isEnabled(tear)) {
            return actionResult;
        }
        if (!player.isShiftKeyDown() && !InfernalTearItem.getStackFromTear(tear).isEmpty()) {
            this.resetTear(tear);
            return actionResult;
        }
        if (!InfernalTearItem.getStackFromTear(tear).isEmpty()) {
            return actionResult;
        }
        if (!(!player.isShiftKeyDown() && this.isEnabled(tear) || (returnStack = this.buildTear(tear, playerInventory = InventoryHelper.getMainInventoryItemHandlerFrom(player))).isEmpty())) {
            return InteractionResult.SUCCESS.heldItemTransformedTo(returnStack);
        }
        if (this.isEnabled(tear)) {
            this.toggleEnabled(tear);
        }
        return actionResult;
    }

    private ItemStack buildTear(ItemStack stack, IItemHandler inventory) {
        ItemStack tear = new ItemStack((ItemLike)this, 1);
        ItemStack target = this.getTargetAlkahestItem(stack, inventory);
        if (target.isEmpty()) {
            return ItemStack.EMPTY;
        }
        InfernalTearItem.setTearTarget(tear, target);
        if (Boolean.TRUE.equals(Config.COMMON.items.infernalTear.absorbWhenCreated.get())) {
            stack.set(ModDataComponents.ENABLED, (Object)true);
        }
        return tear;
    }

    public static void setTearTarget(ItemStack tear, ItemStack target) {
        tear.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(List.of(target)));
    }

    private ItemStack getTargetAlkahestItem(ItemStack self, IItemHandler inventory) {
        ItemStack targetItem = ItemStack.EMPTY;
        int itemQuantity = 0;
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (stack.isEmpty() || self.getItem() == stack.getItem() || stack.getMaxStackSize() == 1 || !stack.getComponentsPatch().isEmpty() || Config.COMMON.items.infernalTear.getItemExperience(RegistryHelper.getItemRegistryName(stack.getItem())).isEmpty() || InventoryHelper.getItemQuantity(stack, inventory) <= itemQuantity) continue;
            itemQuantity = InventoryHelper.getItemQuantity(stack, inventory);
            targetItem = stack.copy();
        }
        return targetItem;
    }
}

