/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.function.Consumer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import reliquary.item.ICreativeTabItemGenerator;
import reliquary.item.ItemBase;

public class MercyCrossItem
extends ItemBase
implements ICreativeTabItemGenerator {
    public MercyCrossItem(Item.Properties properties) {
        super(properties.sword(ToolMaterial.GOLD, 6.0f, -2.4f).stacksTo(1).durability(64).rarity(Rarity.EPIC));
        NeoForge.EVENT_BUS.addListener(this::handleDamage);
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    private void handleDamage(AttackEntityEvent event) {
        Entity entity;
        if (event.getEntity().level().isClientSide || !((entity = event.getTarget()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        if (event.getEntity().getMainHandItem().getItem() != this) {
            return;
        }
        this.updateAttackDamageModifier(target, event.getEntity());
    }

    private void updateAttackDamageModifier(LivingEntity target, Player player) {
        double dmg = this.isUndead(target) ? 12.0 : 6.0;
        AttributeInstance attackAttribute = player.getAttribute(Attributes.ATTACK_DAMAGE);
        if (attackAttribute != null && (attackAttribute.getModifier(BASE_ATTACK_DAMAGE_ID) == null || attackAttribute.getModifier(BASE_ATTACK_DAMAGE_ID).amount() != dmg)) {
            attackAttribute.removeModifier(BASE_ATTACK_DAMAGE_ID);
            attackAttribute.addTransientModifier(new AttributeModifier(BASE_ATTACK_DAMAGE_ID, dmg, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity monster) {
        Mob mob;
        if (monster instanceof Mob && this.isUndead((LivingEntity)(mob = (Mob)monster))) {
            monster.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, monster.getX() + (double)(player.level().random.nextFloat() - 0.5f), monster.getY() + (double)(player.level().random.nextFloat() - 0.5f) + (double)(monster.getBbHeight() / 2.0f), monster.getZ() + (double)(player.level().random.nextFloat() - 0.5f), 0.0, 0.0, 0.0);
        }
        return super.onLeftClickEntity(stack, player, monster);
    }

    private boolean isUndead(LivingEntity e) {
        return e.getType().is(EntityTypeTags.UNDEAD);
    }
}

