/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.IItemHandler;
import reliquary.init.ModDataComponents;
import reliquary.item.ChargeableItem;
import reliquary.item.util.ICuriosItem;
import reliquary.reference.Config;
import reliquary.util.InventoryHelper;
import reliquary.util.RegistryHelper;
import reliquary.util.TooltipBuilder;

public class MidasTouchstoneItem
extends ChargeableItem
implements ICuriosItem {
    private final ItemStack goldRepairItem = new ItemStack((ItemLike)Items.GOLD_INGOT);
    private final ItemStack netheriteRepairItem = new ItemStack((ItemLike)Items.NETHERITE_INGOT);

    public MidasTouchstoneItem(Item.Properties properties) {
        super(properties.stacksTo(1).rarity(Rarity.EPIC));
    }

    @Override
    protected void addMoreInformation(ItemStack touchstone, @Nullable HolderLookup.Provider registries, TooltipBuilder tooltipBuilder) {
        tooltipBuilder.charge(this, ".tooltip2", MidasTouchstoneItem.getGlowstoneCharge(touchstone));
        if (this.isEnabled(touchstone)) {
            tooltipBuilder.absorbActive(Items.GLOWSTONE_DUST.getName(new ItemStack((ItemLike)Items.GLOWSTONE_DUST)).getString());
        } else {
            tooltipBuilder.absorb();
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        Player player;
        if (level.isClientSide || !(entity instanceof Player) || (player = (Player)entity).isSpectator() || level.getGameTime() % 10L != 0L) {
            return;
        }
        if (!stack.has(ModDataComponents.PARTIAL_CHARGES)) {
            this.getMigratedStoredCharge(stack, 0);
        }
        if (this.isEnabled(stack)) {
            int glowstoneCharge = MidasTouchstoneItem.getGlowstoneCharge(stack);
            this.consumeAndCharge(stack, 0, player, this.getGlowstoneLimit() - glowstoneCharge, 1, 16);
        }
        this.doRepairAndDamageTouchstone(stack, player);
    }

    @Override
    protected boolean isItemValidForContainerSlot(ItemStack containerStack, int slot, ItemStack stack) {
        return stack.is(Items.GLOWSTONE_DUST);
    }

    public static int getGlowstoneCharge(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.GLOWSTONE, (Object)0);
    }

    private void doRepairAndDamageTouchstone(ItemStack touchstone, Player player) {
        if (MidasTouchstoneItem.getGlowstoneCharge(touchstone) <= 0) {
            return;
        }
        List<String> goldItems = Config.COMMON.items.midasTouchstone.getGoldItems();
        IItemHandler playerInventory = InventoryHelper.getItemHandlerFrom(player);
        if (playerInventory == null) {
            return;
        }
        for (int slot = 0; slot < playerInventory.getSlots(); ++slot) {
            ItemStack stack = playerInventory.getStackInSlot(slot);
            Item item = stack.getItem();
            if (stack.getDamageValue() <= 0 || !stack.has(DataComponents.DAMAGE)) continue;
            this.tryRepairingItem(touchstone, player, goldItems, stack, item);
        }
    }

    private void tryRepairingItem(ItemStack touchstone, Player player, List<String> goldItems, ItemStack stack, Item item) {
        if (this.isRepairableWithGoldOrNetherite(stack) || goldItems.contains(RegistryHelper.getItemRegistryName(item))) {
            this.repairItem(stack, touchstone, player);
        }
    }

    private boolean isRepairableWithGoldOrNetherite(ItemStack stack) {
        Repairable repairable = (Repairable)stack.get(DataComponents.REPAIRABLE);
        if (repairable == null) {
            return false;
        }
        return repairable.isValidRepairItem(this.goldRepairItem) || repairable.isValidRepairItem(this.netheriteRepairItem);
    }

    private void repairItem(ItemStack stack, ItemStack touchstone, Player player) {
        if (this.reduceTouchStoneCharge(touchstone, player)) {
            int damage = stack.getDamageValue();
            stack.setDamageValue(damage - Math.min(damage, 10));
        }
    }

    private boolean reduceTouchStoneCharge(ItemStack stack, Player player) {
        return player.isCreative() || this.useCharge(stack, this.getGlowStoneCost());
    }

    private int getGlowStoneCost() {
        return (Integer)Config.COMMON.items.midasTouchstone.glowstoneCost.get();
    }

    private int getGlowStoneWorth() {
        return (Integer)Config.COMMON.items.midasTouchstone.glowstoneWorth.get();
    }

    private int getGlowstoneLimit() {
        return (Integer)Config.COMMON.items.midasTouchstone.glowstoneLimit.get();
    }

    @Override
    public ICuriosItem.Type getCuriosType() {
        return ICuriosItem.Type.CHARM;
    }

    @Override
    public void onWornServerTick(ItemStack stack, ServerLevel serverLevel, LivingEntity player) {
        this.inventoryTick(stack, serverLevel, (Entity)player, null);
    }

    @Override
    public void addStoredCharge(ItemStack containerStack, int slot, int chargeToAdd, @Nullable ItemStack chargeStack) {
        containerStack.set(ModDataComponents.GLOWSTONE, (Object)Math.max(MidasTouchstoneItem.getGlowstoneCharge(containerStack) + chargeToAdd, 0));
    }

    @Override
    protected int getSlotWorth(int slot) {
        return slot == 0 ? this.getGlowStoneWorth() : 0;
    }

    @Override
    public int getStoredCharge(ItemStack containerStack, int slot) {
        return MidasTouchstoneItem.getGlowstoneCharge(containerStack);
    }
}

