/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.function.Consumer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import reliquary.item.ItemBase;
import reliquary.item.util.IPotionItem;
import reliquary.reference.Config;
import reliquary.util.potions.PotionEssence;
import reliquary.util.potions.PotionHelper;
import reliquary.util.potions.PotionMap;

public class PotionEssenceItem
extends ItemBase
implements IPotionItem {
    public PotionEssenceItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        if (Boolean.TRUE.equals(Config.COMMON.disable.disablePotions.get())) {
            return;
        }
        for (PotionEssence essence : PotionMap.uniquePotionEssences) {
            ItemStack essenceItem = new ItemStack((ItemLike)this, 1);
            PotionHelper.addPotionContentsToStack(essenceItem, essence.getPotionContents());
            itemConsumer.accept(essenceItem);
        }
    }

    @Override
    public PotionContents getPotionContents(ItemStack stack) {
        return (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
    }
}

