/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import reliquary.init.ModDataComponents;
import reliquary.item.ChargeableItem;
import reliquary.item.util.IScrollableItem;
import reliquary.reference.Config;
import reliquary.util.RegistryHelper;
import reliquary.util.TooltipBuilder;

public class RendingGaleItem
extends ChargeableItem
implements IScrollableItem {
    private static final int NO_DAMAGE_ELYTRA_TICKS = 3;

    public RendingGaleItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @Override
    public MutableComponent getName(ItemStack stack) {
        return super.getName(stack).withStyle(ChatFormatting.YELLOW);
    }

    @Override
    protected void addMoreInformation(ItemStack rendingGale, @Nullable HolderLookup.Provider registries, TooltipBuilder tooltipBuilder) {
        tooltipBuilder.charge(this, ".tooltip2", this.getFeatherCount(rendingGale) / 100);
        tooltipBuilder.description(this, ".tooltip.controls", new Object[0]);
        if (this.isEnabled(rendingGale)) {
            tooltipBuilder.absorbActive(Items.FEATHER.getName(new ItemStack((ItemLike)Items.FEATHER)).getString());
        } else {
            tooltipBuilder.absorb();
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    private static int getChargeLimit() {
        return (Integer)Config.COMMON.items.rendingGale.chargeLimit.get();
    }

    public static int getChargeCost() {
        return (Integer)Config.COMMON.items.rendingGale.castChargeCost.get();
    }

    private static int getFeathersWorth() {
        return (Integer)Config.COMMON.items.rendingGale.chargeFeatherWorth.get();
    }

    private static int getBoltChargeCost() {
        return (Integer)Config.COMMON.items.rendingGale.boltChargeCost.get();
    }

    private static int getBoltTargetRange() {
        return (Integer)Config.COMMON.items.rendingGale.blockTargetRange.get();
    }

    private static int getRadialPushRadius() {
        return (Integer)Config.COMMON.items.rendingGale.pushPullRadius.get();
    }

    private void attemptFlight(LivingEntity livingEntity) {
        double distance;
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        BlockHitResult rayTrace = RendingGaleItem.getPlayerPOVHitResult((Level)player.level(), (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        Vec3 motion = player.getLookAngle().multiply(2.0, 2.0, 2.0);
        if (rayTrace.getType() == HitResult.Type.BLOCK && (distance = player.blockPosition().distSqr((Vec3i)rayTrace.getBlockPos())) < 40.0) {
            double slowDownFactor = distance / 40.0;
            motion = player.getLookAngle().multiply(slowDownFactor, slowDownFactor, slowDownFactor);
        }
        player.setDeltaMovement(motion);
        player.fallDistance = 0.0;
        if (player.isFallFlying()) {
            player.fallFlyTicks = 3;
        }
    }

    public void inventoryTick(ItemStack rendingGale, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        Player player;
        block6: {
            block5: {
                if (level.isClientSide || !(entity instanceof Player)) break block5;
                player = (Player)entity;
                if (level.getGameTime() % 10L == 0L) break block6;
            }
            return;
        }
        if (!rendingGale.has(ModDataComponents.PARTIAL_CHARGES)) {
            this.getMigratedStoredCharge(rendingGale, 0);
        }
        if (this.isEnabled(rendingGale)) {
            int currentFeatherCharge = this.getFeatherCount(rendingGale);
            this.consumeAndCharge(rendingGale, 0, player, RendingGaleItem.getChargeLimit() - currentFeatherCharge, 1, 16);
        }
    }

    public Mode getMode(ItemStack stack) {
        return (Mode)((Object)stack.getOrDefault(ModDataComponents.RENDING_GALE_MODE, (Object)Mode.FLIGHT));
    }

    private void setMode(ItemStack stack, Mode mode) {
        stack.set(ModDataComponents.RENDING_GALE_MODE, (Object)mode);
    }

    private void cycleMode(ItemStack stack, boolean isRaining, boolean next) {
        Mode modeToSet;
        Mode currentMode = this.getMode(stack);
        Mode mode = modeToSet = next ? currentMode.next() : currentMode.previous();
        if (!isRaining && modeToSet == Mode.BOLT) {
            modeToSet = next ? modeToSet.next() : modeToSet.previous();
        }
        this.setMode(stack, modeToSet);
    }

    @Override
    public InteractionResult onMouseScrolled(ItemStack stack, Player player, double scrollDelta) {
        if (player.level().isClientSide) {
            return InteractionResult.PASS;
        }
        this.cycleMode(stack, player.level().isRaining(), scrollDelta > 0.0);
        return InteractionResult.SUCCESS;
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 6000;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.NONE;
    }

    @Override
    protected boolean isItemValidForContainerSlot(ItemStack containerStack, int slot, ItemStack stack) {
        return stack.is(Items.FEATHER) && slot == 0;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (player.isShiftKeyDown()) {
            return super.use(level, player, hand);
        }
        player.startUsingItem(hand);
        return InteractionResult.SUCCESS;
    }

    @Override
    public void addStoredCharge(ItemStack containerStack, int slot, int chargeToAdd, @Nullable ItemStack chargeStack) {
        int featherCount = Math.max(0, Math.min(RendingGaleItem.getChargeLimit(), this.getFeatherCount(containerStack) + chargeToAdd));
        this.runOnHandler(containerStack, handler -> handler.setStackInSlot(0, featherCount == 0 ? ItemStack.EMPTY : new ItemStack((ItemLike)Items.FEATHER, featherCount)));
    }

    @Override
    public int getStoredCharge(ItemStack containerStack, int slot) {
        return this.getFeatherCount(containerStack);
    }

    @Override
    protected int getSlotWorth(int slot) {
        return slot == 0 ? RendingGaleItem.getFeathersWorth() : 0;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack rendingGale, int remainingUseDuration) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (this.getTotalCharge(rendingGale) <= 0) {
            player.releaseUsingItem();
            return;
        }
        if (this.getMode(rendingGale) == Mode.BOLT) {
            if (remainingUseDuration % 8 == 0) {
                this.spawnBolt(rendingGale, player);
            }
        } else {
            if (this.getMode(rendingGale) == Mode.FLIGHT) {
                this.attemptFlight((LivingEntity)player);
                this.spawnFlightParticles(player.level(), player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ(), player);
            } else if (this.getMode(rendingGale) == Mode.PUSH) {
                this.doRadialPush(player.level(), player.getX(), player.getY(), player.getZ(), player, false);
            } else if (this.getMode(rendingGale) == Mode.PULL) {
                this.doRadialPush(player.level(), player.getX(), player.getY(), player.getZ(), player, true);
            }
            if (!player.level().isClientSide) {
                this.useCharge(rendingGale, 0, RendingGaleItem.getChargeCost());
            }
        }
    }

    private void spawnBolt(ItemStack rendingGale, Player player) {
        HitResult rayTraceResult = player.pick((double)RendingGaleItem.getBoltTargetRange(), 1.0f, true);
        if (rayTraceResult.getType() == HitResult.Type.BLOCK) {
            LightningBolt bolt;
            BlockHitResult blockRayTraceResult = (BlockHitResult)rayTraceResult;
            BlockPos pos = blockRayTraceResult.getBlockPos();
            int attemptedY = pos.getY();
            if (!player.level().isRainingAt(pos)) {
                ++attemptedY;
            }
            if (!player.level().isClientSide && player.level().isRainingAt(new BlockPos(pos.getX(), attemptedY, pos.getZ())) && (bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(player.level(), EntitySpawnReason.EVENT)) != null) {
                bolt.snapTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                player.level().addFreshEntity((Entity)bolt);
                this.useCharge(rendingGale, 0, RendingGaleItem.getBoltChargeCost());
            }
        }
    }

    public boolean hasFlightCharge(ItemStack stack) {
        return this.getFeatherCount(stack) > 0;
    }

    public int getFeatherCount(ItemStack rendingGale) {
        return this.getFromHandler(rendingGale, handler -> handler.getCountInSlot(0));
    }

    public void doRadialPush(Level level, double posX, double posY, double posZ, @Nullable Player player, boolean pull) {
        this.spawnRadialHurricaneParticles(level, posX, posY, posZ, player, pull);
        if (level.isClientSide) {
            return;
        }
        double lowerX = posX - (double)RendingGaleItem.getRadialPushRadius();
        double lowerY = posY - (double)RendingGaleItem.getRadialPushRadius() / 5.0;
        double lowerZ = posZ - (double)RendingGaleItem.getRadialPushRadius();
        double upperX = posX + (double)RendingGaleItem.getRadialPushRadius();
        double upperY = posY + (double)RendingGaleItem.getRadialPushRadius() / 5.0;
        double upperZ = posZ + (double)RendingGaleItem.getRadialPushRadius();
        List entities = level.getEntitiesOfClass(Entity.class, new AABB(lowerX, lowerY, lowerZ, upperX, upperY, upperZ), e -> e instanceof Mob || e instanceof Projectile);
        for (Entity entity : entities) {
            double distance = this.getDistanceToEntity(posX, posY, posZ, entity);
            if (!(distance < (double)RendingGaleItem.getRadialPushRadius()) || this.isBlacklistedEntity(entity) || entity.equals((Object)player)) continue;
            Vec3 pushVector = pull ? new Vec3(posX - entity.getX(), posY - entity.getY(), posZ - entity.getZ()) : new Vec3(entity.getX() - posX, entity.getY() - posY, entity.getZ() - posZ);
            pushVector = pushVector.normalize();
            entity.move(MoverType.PLAYER, new Vec3(0.0, 0.2, 0.0));
            entity.move(MoverType.PLAYER, new Vec3(pushVector.x, Math.min(pushVector.y, 0.1) * 1.5, pushVector.z));
        }
    }

    private boolean isBlacklistedEntity(Entity entity) {
        String entityName = RegistryHelper.getRegistryName(entity).toString();
        return this.isBlacklistedLivingEntity(entity, entityName) || (Boolean)Config.COMMON.items.rendingGale.canPushProjectiles.get() != false && this.isBlacklistedProjectile(entity, entityName);
    }

    private boolean isBlacklistedProjectile(Entity entity, String entityName) {
        return entity instanceof Projectile && ((List)Config.COMMON.items.rendingGale.pushableProjectilesBlacklist.get()).contains(entityName);
    }

    private boolean isBlacklistedLivingEntity(Entity entity, String entityName) {
        return entity instanceof Mob && ((List)Config.COMMON.items.rendingGale.pushableEntitiesBlacklist.get()).contains(entityName);
    }

    private float getDistanceToEntity(double posX, double posY, double posZ, Entity entityIn) {
        float f = (float)(posX - entityIn.getX());
        float f1 = (float)(posY - entityIn.getY());
        float f2 = (float)(posZ - entityIn.getZ());
        return Mth.sqrt((float)(f * f + f1 * f1 + f2 * f2));
    }

    private void spawnFlightParticles(Level level, double x, double y, double z, Player player) {
        Vec3 lookVector = player.getLookAngle();
        BlockParticleOption blockParticleData = new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SNOW_BLOCK.defaultBlockState());
        for (int i = 0; i < 8; ++i) {
            float randX = 10.0f * (level.random.nextFloat() - 0.5f);
            float randY = 10.0f * (level.random.nextFloat() - 0.5f);
            float randZ = 10.0f * (level.random.nextFloat() - 0.5f);
            level.addParticle((ParticleOptions)blockParticleData, x + (double)randX + lookVector.x * 20.0, y + (double)randY + lookVector.y * 20.0, z + (double)randZ + lookVector.z * 20.0, -lookVector.x * 5.0, -lookVector.y * 5.0, -lookVector.z * 5.0);
        }
    }

    private void spawnRadialHurricaneParticles(Level level, double posX, double posY, double posZ, @Nullable Player player, boolean pull) {
        BlockParticleOption blockParticleData = new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SNOW_BLOCK.defaultBlockState());
        for (int i = 0; i < 3; ++i) {
            float randX = level.random.nextFloat() - 0.5f;
            float randZ = level.random.nextFloat() - 0.5f;
            float motX = randX * 10.0f;
            float motZ = randZ * 10.0f;
            if (pull) {
                randX *= 10.0f;
                randZ *= 10.0f;
                motX *= -1.0f;
                motZ *= -1.0f;
            }
            double posYAdjusted = player == null ? posY : posY + (double)player.getEyeHeight() - (double)(player.getBbHeight() / 2.0f);
            level.addParticle((ParticleOptions)blockParticleData, posX + (double)randX, posYAdjusted, posZ + (double)randZ, (double)motX, 0.0, (double)motZ);
        }
    }

    public static enum Mode implements StringRepresentable
    {
        FLIGHT,
        PUSH,
        PULL,
        BOLT;

        public static final Codec<Mode> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Mode> STREAM_CODEC;
        private static final Mode[] VALUES;

        public String getSerializedName() {
            return this.name();
        }

        public Mode next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public Mode previous() {
            return VALUES[Math.floorMod(this.ordinal() - 1, VALUES.length)];
        }

        static {
            CODEC = StringRepresentable.fromEnum(Mode::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Mode.class);
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Mode value : Mode.values()) {
                builder.put((Object)value.getSerializedName(), (Object)value);
            }
            VALUES = Mode.values();
        }
    }
}

