/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import reliquary.entity.LyssaHook;
import reliquary.init.ModDataComponents;
import reliquary.item.ItemBase;

public class RodOfLyssaItem
extends ItemBase {
    public RodOfLyssaItem(Item.Properties properties) {
        super(properties.stacksTo(1).enchantable(1));
    }

    public static int getHookEntityId(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.HOOK_ENTITY_ID, (Object)0);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        Entity entity;
        ItemStack stack = player.getItemInHand(hand);
        int entityId = RodOfLyssaItem.getHookEntityId(stack);
        if (entityId != 0 && (entity = level.getEntity(entityId)) instanceof LyssaHook) {
            LyssaHook hook = (LyssaHook)entity;
            player.swing(hand);
            hook.handleHookRetraction(stack);
            this.setHookEntityId(stack, 0);
        } else {
            level.playSound(null, player.blockPosition(), SoundEvents.ARROW_SHOOT, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
            if (!level.isClientSide) {
                Registry registrylookup = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
                int lureLevel = EnchantmentHelper.getEnchantmentLevel((Holder)registrylookup.getOrThrow(Enchantments.LURE), (LivingEntity)player);
                int luckOfTheSeaLevel = EnchantmentHelper.getEnchantmentLevel((Holder)registrylookup.getOrThrow(Enchantments.LUCK_OF_THE_SEA), (LivingEntity)player);
                LyssaHook hook = new LyssaHook(level, player, lureLevel, luckOfTheSeaLevel);
                level.addFreshEntity((Entity)hook);
                this.setHookEntityId(stack, hook.getId());
            }
            player.swing(hand);
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(stack);
    }

    private void setHookEntityId(ItemStack stack, int entityId) {
        stack.set(ModDataComponents.HOOK_ENTITY_ID, (Object)entityId);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_FISHING_ROD_ACTIONS.contains(itemAbility);
    }
}

