/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;
import reliquary.entity.KrakenSlime;
import reliquary.item.ItemBase;

public class SerpentStaffItem
extends ItemBase {
    public SerpentStaffItem(Item.Properties properties) {
        super(properties.durability(200).setNoCombineRepair());
    }

    @Override
    public MutableComponent getName(ItemStack stack) {
        return super.getName(stack).withStyle(ChatFormatting.DARK_GREEN);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BLOCK;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack serpentStaff, int remainingUseDuration) {
        Player player;
        block3: {
            block2: {
                if (livingEntity.level().isClientSide || !(livingEntity instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (remainingUseDuration % 3 == 0) break block3;
            }
            return;
        }
        this.shootKrakenSlime(serpentStaff, player);
    }

    private void shootKrakenSlime(ItemStack serpentStaff, Player player) {
        player.level().playSound(null, player.blockPosition(), SoundEvents.ARROW_SHOOT, SoundSource.NEUTRAL, 0.5f, 0.4f / (player.level().random.nextFloat() * 0.4f + 0.8f));
        KrakenSlime krakenSlime = new KrakenSlime(player.level(), player);
        krakenSlime.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
        player.level().addFreshEntity((Entity)krakenSlime);
        serpentStaff.hurtAndBreak(1, (LivingEntity)player, player.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
    }

    public boolean releaseUsing(ItemStack serpentStaff, Level level, LivingEntity livingEntity, int timeLeft) {
        if (!livingEntity.level().isClientSide && timeLeft + 2 >= serpentStaff.getUseDuration(livingEntity) && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.shootKrakenSlime(serpentStaff, player);
            return true;
        }
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int drain = player.level().random.nextInt(4);
        if (entity.hurtServer(serverLevel, player.damageSources().playerAttack(player), (float)drain)) {
            player.heal((float)drain);
            stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        }
        return false;
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 11;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResult.SUCCESS;
    }
}

