/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import reliquary.entity.TippedArrow;
import reliquary.item.ICreativeTabItemGenerator;
import reliquary.item.util.IPotionItem;
import reliquary.reference.Config;
import reliquary.util.potions.PotionEssence;
import reliquary.util.potions.PotionHelper;
import reliquary.util.potions.PotionMap;

public class TippedArrowItem
extends ArrowItem
implements IPotionItem,
ICreativeTabItemGenerator {
    public TippedArrowItem(Item.Properties properties) {
        super(properties);
    }

    public AbstractArrow createArrow(Level level, ItemStack arrowStack, LivingEntity shooter, @Nullable ItemStack projectileWeaponStack) {
        TippedArrow arrowEntity = new TippedArrow(level, shooter, arrowStack, projectileWeaponStack);
        arrowEntity.setPotionEffect(arrowStack);
        return arrowEntity;
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        if (Boolean.TRUE.equals(Config.COMMON.disable.disablePotions.get())) {
            return;
        }
        for (PotionEssence essence : PotionMap.uniquePotionEssences) {
            ItemStack tippedArrow = new ItemStack((ItemLike)this);
            PotionHelper.addPotionContentsToStack(tippedArrow, PotionHelper.changePotionEffectsDuration(essence.getPotionContents(), 0.125f));
            itemConsumer.accept(tippedArrow);
        }
    }

    @Override
    public PotionContents getPotionContents(ItemStack stack) {
        return (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
    }
}

