/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import reliquary.item.ToggleableItem;
import reliquary.item.util.ICuriosItem;
import reliquary.reference.Config;
import reliquary.util.InventoryHelper;
import reliquary.util.MobHelper;

public class TwilightCloakItem
extends ToggleableItem
implements ICuriosItem {
    public TwilightCloakItem(Item.Properties properties) {
        super(properties.stacksTo(1).rarity(Rarity.EPIC));
        NeoForge.EVENT_BUS.addListener(this::onEntityTargetedEvent);
        NeoForge.EVENT_BUS.addListener(this::onLivingUpdate);
    }

    public void inventoryTick(ItemStack twilightCloak, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        Player player;
        if (level.isClientSide() || !(entity instanceof Player) || (player = (Player)entity).isSpectator()) {
            return;
        }
        this.updateInvisibility(twilightCloak, (Player)entity);
    }

    private void updateInvisibility(ItemStack twilightCloak, Player player) {
        if (!this.isEnabled(twilightCloak)) {
            return;
        }
        if (player.level().getMaxLocalRawBrightness(player.blockPosition()) > (Integer)Config.COMMON.items.twilightCloak.maxLightLevel.get()) {
            return;
        }
        MobEffectInstance quickInvisibility = new MobEffectInstance(MobEffects.INVISIBILITY, 2, 0, false, false);
        player.addEffect(quickInvisibility);
    }

    @Override
    public ICuriosItem.Type getCuriosType() {
        return ICuriosItem.Type.BODY;
    }

    @Override
    public void onWornTick(ItemStack twilightCloak, LivingEntity player) {
        this.updateInvisibility(twilightCloak, (Player)player);
    }

    private void onEntityTargetedEvent(LivingChangeTargetEvent event) {
        if (this.shouldResetTarget((Entity)event.getNewAboutToBeSetTarget())) {
            event.setCanceled(true);
        }
    }

    private void onLivingUpdate(EntityTickEvent.Pre event) {
        this.doTwilightCloakCheck(event);
    }

    private void doTwilightCloakCheck(EntityTickEvent.Pre event) {
        Mob entityLiving;
        Entity entity = event.getEntity();
        if (entity instanceof Mob && this.shouldResetTarget((Entity)(entityLiving = (Mob)entity).getTarget())) {
            MobHelper.resetTarget(entityLiving);
        }
    }

    private boolean shouldResetTarget(@Nullable Entity target) {
        if (!(target instanceof Player)) {
            return false;
        }
        Player player = (Player)target;
        return InventoryHelper.playerHasItem(player, this, true) && player.level().getMaxLocalRawBrightness(player.blockPosition()) <= (Integer)Config.COMMON.items.twilightCloak.maxLightLevel.get();
    }
}

