/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item.util;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface ICuriosItem {
    public Type getCuriosType();

    default public void onWornTick(ItemStack stack, LivingEntity player) {
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.onWornServerTick(stack, serverLevel, player);
        } else {
            this.onWornClientTick(stack, player);
        }
    }

    default public void onWornServerTick(ItemStack stack, ServerLevel serverLevel, LivingEntity player) {
    }

    default public void onWornClientTick(ItemStack stack, LivingEntity player) {
    }

    default public void onEquipped(String identifier, LivingEntity player) {
    }

    public static enum Type {
        BELT("belt"),
        NECKLACE("necklace"),
        BODY("body"),
        CHARM("charm"),
        RING("ring"),
        NONE("none");

        private final String identifier;

        private Type(String identifier) {
            this.identifier = identifier;
        }

        public String getIdentifier() {
            return this.identifier;
        }
    }
}

