/*
 * Decompiled with CFR 0.152.
 */
package reliquary.pedestal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import reliquary.api.IPedestalItemWrapper;

public class PedestalRegistry {
    private static final PedestalRegistry INSTANCE = new PedestalRegistry();
    private static final Map<LocationKey, BlockPos> positions = new HashMap<LocationKey, BlockPos>();
    private final Map<Predicate<ItemStack>, Supplier<? extends IPedestalItemWrapper>> itemWrappers = new HashMap<Predicate<ItemStack>, Supplier<? extends IPedestalItemWrapper>>();
    private final Map<Class<? extends Block>, Supplier<? extends IPedestalItemWrapper>> blockWrappers = new HashMap<Class<? extends Block>, Supplier<? extends IPedestalItemWrapper>>();

    public static void registerItemWrapper(Predicate<ItemStack> itemMatcher, Supplier<? extends IPedestalItemWrapper> wrapperClass) {
        PedestalRegistry.INSTANCE.itemWrappers.put(itemMatcher, wrapperClass);
    }

    public static void registerItemWrapper(Class<? extends Item> itemClass, Supplier<? extends IPedestalItemWrapper> wrapperClass) {
        PedestalRegistry.registerItemWrapper((ItemStack itemStack) -> itemClass.isInstance(itemStack.getItem()), wrapperClass);
    }

    public static void registerItemBlockWrapper(Class<? extends Block> blockClass, Supplier<? extends IPedestalItemWrapper> wrapperClass) {
        PedestalRegistry.INSTANCE.blockWrappers.put(blockClass, wrapperClass);
    }

    public static Optional<IPedestalItemWrapper> getItemWrapper(ItemStack item) {
        Optional<Supplier> matchedItemWrapper = PedestalRegistry.INSTANCE.itemWrappers.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(item)).map(Map.Entry::getValue).findFirst();
        if (matchedItemWrapper.isEmpty()) {
            return PedestalRegistry.INSTANCE.blockWrappers.entrySet().stream().filter(entry -> {
                Item patt0$temp = item.getItem();
                if (!(patt0$temp instanceof BlockItem)) return false;
                BlockItem blockItem = (BlockItem)patt0$temp;
                if (!((Class)entry.getKey()).isInstance(blockItem.getBlock())) return false;
                return true;
            }).map(Map.Entry::getValue).findFirst().map(Supplier::get);
        }
        return matchedItemWrapper.map(Supplier::get);
    }

    public static void registerPosition(ResourceLocation dimension, BlockPos pos) {
        LocationKey key = new LocationKey(dimension, pos.asLong());
        positions.putIfAbsent(key, pos);
    }

    public static void unregisterPosition(ResourceLocation dimension, BlockPos pos) {
        positions.remove(new LocationKey(dimension, pos.asLong()));
    }

    private static void clearPositions() {
        positions.clear();
    }

    public static List<BlockPos> getPositionsInRange(ResourceLocation dimension, BlockPos startPos, int range) {
        return PedestalRegistry.getPositionsInRange(dimension, startPos, range, range, range);
    }

    private static List<BlockPos> getPositionsInRange(ResourceLocation dimension, BlockPos startPos, int xRange, int yRange, int zRange) {
        ArrayList<BlockPos> positionsInRange = new ArrayList<BlockPos>();
        for (Map.Entry<LocationKey, BlockPos> position : positions.entrySet()) {
            BlockPos pos;
            if (!position.getKey().getDimension().equals((Object)dimension) || (pos = position.getValue()).getX() < startPos.getX() - xRange || pos.getX() > startPos.getX() + xRange || pos.getY() < startPos.getY() - yRange || pos.getY() > startPos.getY() + yRange || pos.getZ() < startPos.getZ() - zRange || pos.getZ() > startPos.getZ() + zRange) continue;
            positionsInRange.add(pos);
        }
        return positionsInRange;
    }

    public static void serverStopping(ServerStoppedEvent event) {
        PedestalRegistry.clearPositions();
    }

    private record LocationKey(ResourceLocation dimension, long location) {
        @Override
        public int hashCode() {
            return Objects.hash(this.dimension, this.location);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof LocationKey)) {
                return false;
            }
            LocationKey key2 = (LocationKey)o;
            return this.getDimension().equals((Object)key2.getDimension()) && this.getLocation() == key2.getLocation();
        }

        ResourceLocation getDimension() {
            return this.dimension;
        }

        public long getLocation() {
            return this.location;
        }
    }
}

