/*
 * Decompiled with CFR 0.152.
 */
package reliquary.pedestal.wrappers;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalActionItemWrapper;
import reliquary.init.ModEffects;
import reliquary.init.ModItems;
import reliquary.item.RendingGaleItem;
import reliquary.reference.Config;

public class PedestalRendingGaleWrapper
implements IPedestalActionItemWrapper {
    private static final int SECONDS_BETWEEN_BUFF_CHECKS = 2;
    private static final int TICKS_BETWEEN_PUSH_PULL_CHECKS = 1;
    private int buffCheckCoolDown;
    private int pushPullCheckCoolDown;

    @Override
    public void update(ItemStack stack, Level level, IPedestal pedestal) {
        BlockPos pos = pedestal.getBlockPosition();
        RendingGaleItem rendingGale = (RendingGaleItem)stack.getItem();
        if (rendingGale.getMode(stack) == RendingGaleItem.Mode.FLIGHT) {
            if (this.buffCheckCoolDown <= 0) {
                this.buffPlayersWithFlight(stack, level, pos);
                this.buffCheckCoolDown = 40;
            } else {
                --this.buffCheckCoolDown;
            }
        } else if (rendingGale.getMode(stack) == RendingGaleItem.Mode.PUSH) {
            if (this.pushPullCheckCoolDown <= 0) {
                this.pushEntities(stack, level, pos, rendingGale, false);
                this.pushPullCheckCoolDown = 1;
            } else {
                --this.pushPullCheckCoolDown;
            }
        } else if (rendingGale.getMode(stack) == RendingGaleItem.Mode.PULL) {
            if (this.pushPullCheckCoolDown <= 0) {
                this.pushEntities(stack, level, pos, rendingGale, true);
                this.pushPullCheckCoolDown = 1;
            } else {
                --this.pushPullCheckCoolDown;
            }
        }
    }

    private void pushEntities(ItemStack stack, Level level, BlockPos pos, RendingGaleItem rendingGale, boolean b) {
        rendingGale.doRadialPush(level, pos.getX(), pos.getY(), pos.getZ(), null, b);
        ModItems.RENDING_GALE.get().useCharge(stack, (int)(0.05f * (float)((Integer)Config.COMMON.items.rendingGale.pedestalCostPerSecond.get()).intValue()));
    }

    private void buffPlayersWithFlight(ItemStack stack, Level level, BlockPos pos) {
        List players;
        int flightRange = (Integer)Config.COMMON.items.rendingGale.pedestalFlightRange.get();
        if (ModItems.RENDING_GALE.get().getFeatherCount(stack) >= RendingGaleItem.getChargeCost() * 2 && !(players = level.getEntitiesOfClass(Player.class, new AABB((double)pos.getX() - (double)flightRange, (double)pos.getY() - (double)flightRange, (double)pos.getZ() - (double)flightRange, (double)pos.getX() + (double)flightRange, (double)pos.getY() + (double)flightRange, (double)pos.getZ() + (double)flightRange))).isEmpty()) {
            for (Player player : players) {
                player.addEffect(new MobEffectInstance(ModEffects.FLIGHT, 400, 0, false, false, true));
            }
            ModItems.RENDING_GALE.get().useCharge(stack, 2 * (Integer)Config.COMMON.items.rendingGale.pedestalCostPerSecond.get());
        }
    }

    @Override
    public void onRemoved(ItemStack stack, Level level, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, Level level, IPedestal pedestal) {
    }
}

