/*
 * Decompiled with CFR 0.152.
 */
package reliquary.pedestal.wrappers;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.common.util.FakePlayer;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalActionItemWrapper;
import reliquary.reference.Config;

public class PedestalShearsWrapper
implements IPedestalActionItemWrapper {
    private boolean isShearingBlock = false;
    private BlockPos blockPosBeingSheared;
    private final Queue<BlockPos> blockQueue = new ArrayDeque<BlockPos>();

    @Override
    public void update(ItemStack stack, Level level, IPedestal pedestal) {
        int shearsRange;
        BlockPos pos = pedestal.getBlockPosition();
        if (this.shearAnimals(stack, level, pedestal, pos, shearsRange = ((Integer)Config.COMMON.blocks.pedestal.shearsWrapperRange.get()).intValue())) {
            return;
        }
        if (!this.isShearingBlock) {
            pedestal.setActionCoolDown((Integer)Config.COMMON.blocks.pedestal.shearsWrapperCooldown.get());
        }
        if (stack.getCount() == 0) {
            pedestal.destroyItem();
        }
    }

    private boolean shearAnimals(ItemStack stack, Level level, IPedestal pedestal, BlockPos pos, int shearsRange) {
        return pedestal.getFakePlayer().map(fakePlayer -> {
            if (!this.shearAnimals(stack, level, (FakePlayer)fakePlayer, pos, shearsRange) && !this.shearBlocks(stack, level, pedestal, (FakePlayer)fakePlayer, pos, shearsRange)) {
                pedestal.setActionCoolDown(100);
                return true;
            }
            return false;
        }).orElse(false);
    }

    @Override
    public void onRemoved(ItemStack stack, Level level, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, Level level, IPedestal pedestal) {
    }

    private boolean shearBlocks(ItemStack stack, Level level, IPedestal pedestal, FakePlayer fakePlayer, BlockPos pos, int shearsRange) {
        if (!this.isShearingBlock) {
            if (this.blockQueue.isEmpty()) {
                this.updateQueue(stack, level, pos, shearsRange);
                if (this.blockQueue.isEmpty()) {
                    return false;
                }
            }
            this.blockPosBeingSheared = this.blockQueue.remove();
            BlockState blockState = level.getBlockState(this.blockPosBeingSheared);
            if (this.isShearableBlock(stack, level, blockState)) {
                float hardness = blockState.getDestroySpeed((BlockGetter)level, this.blockPosBeingSheared);
                float digSpeed = stack.getItem().getDestroySpeed(stack, blockState);
                pedestal.setActionCoolDown((int)(hardness * 1.5f * 20.0f / digSpeed));
                this.isShearingBlock = true;
            }
        } else {
            BlockState blockState = level.getBlockState(this.blockPosBeingSheared);
            if (stack.getItem().canDestroyBlock(stack, blockState, level, this.blockPosBeingSheared, (LivingEntity)fakePlayer)) {
                if (blockState.getBlock() instanceof BeehiveBlock) {
                    this.shearBeehive(level, this.blockPosBeingSheared, blockState, stack);
                } else if (level.removeBlock(this.blockPosBeingSheared, false)) {
                    Block.dropResources((BlockState)blockState, (Level)level, (BlockPos)this.blockPosBeingSheared, null, (Entity)fakePlayer, (ItemStack)new ItemStack((ItemLike)Items.SHEARS));
                    level.levelEvent(2001, this.blockPosBeingSheared, Block.getId((BlockState)blockState));
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        stack.hurtAndBreak(1, serverLevel, null, item -> {});
                    }
                }
            }
            this.isShearingBlock = false;
        }
        return true;
    }

    private boolean isShearableBlock(ItemStack stack, Level level, BlockState blockState) {
        IShearable shearable;
        Block block = blockState.getBlock();
        return block instanceof IShearable && (shearable = (IShearable)block).isShearable(null, stack, level, this.blockPosBeingSheared) || block instanceof BeehiveBlock && (Integer)blockState.getValue((Property)BeehiveBlock.HONEY_LEVEL) >= 5;
    }

    private void shearBeehive(Level level, BlockPos pos, BlockState blockState, ItemStack stack) {
        int honeyLevel = (Integer)blockState.getValue((Property)BeehiveBlock.HONEY_LEVEL);
        if (honeyLevel >= 5) {
            level.playSound(null, pos, SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            BeehiveBlock.dropHoneycomb((Level)level, (BlockPos)pos);
            ((BeehiveBlock)blockState.getBlock()).releaseBeesAndResetHoneyLevel(level, blockState, pos, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                stack.hurtAndBreak(1, serverLevel, null, item -> {});
            }
        }
    }

    private void updateQueue(ItemStack stack, Level level, BlockPos pos, int shearsRange) {
        for (int y = pos.getY() - shearsRange; y <= pos.getY() + shearsRange; ++y) {
            for (int x = pos.getX() - shearsRange; x <= pos.getX() + shearsRange; ++x) {
                for (int z = pos.getZ() - shearsRange; z <= pos.getZ() + shearsRange; ++z) {
                    BlockPos currentBlockPos = new BlockPos(x, y, z);
                    BlockState blockState = level.getBlockState(currentBlockPos);
                    if (!this.isShearableBlock(stack, level, blockState)) continue;
                    this.blockQueue.add(currentBlockPos);
                }
            }
        }
    }

    private boolean shearAnimals(ItemStack stack, Level level, FakePlayer fakePlayer, BlockPos pos, int shearsRange) {
        List entities = level.getEntitiesOfClass(Animal.class, AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-shearsRange, -shearsRange, -shearsRange), (BlockPos)pos.offset(shearsRange, shearsRange, shearsRange)));
        for (Animal animal : entities) {
            IShearable shearable;
            if (!(animal instanceof IShearable) || !(shearable = (IShearable)animal).isShearable(null, stack, level, animal.blockPosition())) continue;
            fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, stack);
            fakePlayer.interactOn((Entity)animal, InteractionHand.MAIN_HAND);
            return true;
        }
        return false;
    }
}

