/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.player005.recipe_modification.api.RecipeHelper;

@FunctionalInterface
public interface IngredientSelector {
    public static final IngredientSelector ALL_INGREDIENTS = (recipe, helper) -> (Ingredient[])recipe.m_7527_().toArray(Ingredient[]::new);

    public Ingredient[] selectIngredients(Recipe<?> var1, RecipeHelper var2);

    public static IngredientSelector byOrdinals(int ... numbers) {
        return (recipe, helper) -> (Ingredient[])Arrays.stream(numbers).mapToObj(arg_0 -> ((NonNullList)recipe.m_7527_()).get(arg_0)).toArray(Ingredient[]::new);
    }

    public static IngredientSelector byOrdinals(List<Integer> numbers) {
        return (recipe, helper) -> (Ingredient[])numbers.stream().map(arg_0 -> ((NonNullList)recipe.m_7527_()).get(arg_0)).toArray(Ingredient[]::new);
    }

    public static IngredientSelector byItem(Item item) {
        return (recipe, helper) -> {
            ArrayList<Ingredient> toReturn = new ArrayList<Ingredient>();
            for (Ingredient ingredient : recipe.m_7527_()) {
                for (ItemStack ingredientItem : ingredient.m_43908_()) {
                    if (!ingredientItem.m_150930_(item)) continue;
                    toReturn.add(ingredient);
                }
            }
            return (Ingredient[])toReturn.toArray(Ingredient[]::new);
        };
    }

    public static IngredientSelector matchingItem(Item item) {
        return (recipe, helper) -> {
            ArrayList<Ingredient> toReturn = new ArrayList<Ingredient>();
            for (Ingredient ingredient : recipe.m_7527_()) {
                if (!helper.isExactMatch(ingredient, item)) continue;
                toReturn.add(ingredient);
            }
            return (Ingredient[])toReturn.toArray(Ingredient[]::new);
        };
    }

    public static IngredientSelector matchingTag(TagKey<Item> tag) {
        return (recipe, helper) -> {
            ArrayList<Ingredient> toReturn = new ArrayList<Ingredient>();
            for (Ingredient ingredient : recipe.m_7527_()) {
                if (!helper.matchesTag(ingredient, tag)) continue;
                toReturn.add(ingredient);
            }
            return (Ingredient[])toReturn.toArray(Ingredient[]::new);
        };
    }

    public static IngredientSelector and(IngredientSelector ... selectors) {
        return (recipe, helper) -> {
            ArrayList<Ingredient> toReturn = new ArrayList<Ingredient>();
            for (IngredientSelector selector : selectors) {
                toReturn.addAll(Arrays.asList(selector.selectIngredients(recipe, helper)));
            }
            return (Ingredient[])toReturn.toArray(Ingredient[]::new);
        };
    }
}

