/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.api;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.player005.recipe_modification.api.IngredientSelector;
import net.player005.recipe_modification.api.RecipeHelper;
import net.player005.recipe_modification.api.RecipeModification;

@FunctionalInterface
public interface RecipeModifier {
    public void apply(Recipe<?> var1, RecipeHelper var2);

    public static RecipeModifier removeIngredients(IngredientSelector selector) {
        return (recipe, helper) -> {
            for (Ingredient ingredient : selector.selectIngredients(recipe, helper)) {
                recipe.m_7527_().remove((Object)ingredient);
            }
        };
    }

    public static RecipeModifier addIngredient(Ingredient ingredient) {
        return (recipe, helper) -> recipe.m_7527_().add((Object)ingredient);
    }

    public static RecipeModifier addAlternative(Item original, Item alternative) {
        return (recipe, helper) -> {
            for (Ingredient ingredient : recipe.m_7527_()) {
                if (!ingredient.test(original.m_7968_())) continue;
                helper.addAlternative(ingredient, alternative);
            }
        };
    }

    public static RecipeModifier addAlternative(Item original, TagKey<Item> alternative) {
        return (recipe, helper) -> {
            for (Ingredient ingredient : recipe.m_7527_()) {
                if (!ingredient.test(original.m_7968_())) continue;
                helper.addAlternative(ingredient, alternative);
            }
        };
    }

    public static RecipeModifier addAlternative(IngredientSelector selector, Ingredient alternative) {
        return (recipe, helper) -> {
            for (Ingredient ingredient : selector.selectIngredients(recipe, helper)) {
                helper.addAlternative(ingredient, alternative);
            }
        };
    }

    public static RecipeModifier replaceIngredient(IngredientSelector selector, Ingredient newIngredient) {
        return (recipe, helper) -> {
            Ingredient[] ingredients;
            for (Ingredient ingredient : ingredients = selector.selectIngredients(recipe, helper)) {
                helper.replaceIngredient(ingredient, newIngredient);
            }
        };
    }

    public static RecipeModifier replaceResultItem(Function<ItemStack, ItemStack> modifier) {
        return (recipe, helper) -> RecipeModification.registerGlobalResultModifier((recipe1, result, recipeInput) -> {
            if (recipe1 == recipe) {
                return (ItemStack)modifier.apply(result);
            }
            return result;
        });
    }

    public static RecipeModifier replaceResultItem(ItemStack newResult) {
        return (recipe, helper) -> RecipeModification.replaceResultItem(recipe, newResult);
    }

    public static RecipeModifier modifyResultItem(Consumer<ItemStack> itemStackModifier) {
        return (recipe, helper) -> RecipeModification.modifyResultItemSimple(recipe, itemStackModifier);
    }
}

