/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.player005.recipe_modification.api.Platform;
import net.player005.recipe_modification.api.RecipeHelper;
import net.player005.recipe_modification.impl.IngredientAccessor;
import net.player005.recipe_modification.impl.mixin.RecipeManagerAccessor;
import net.player005.recipe_modification.impl.mixin.TagValueAccessor;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.UnknownNullability;

@NotNullByDefault
public abstract class Platform_1_20_1
implements Platform {
    @ApiStatus.Internal
    public static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownNullability RegistryAccess.Frozen REGISTRY_ACCESS;

    @Override
    public RegistryAccess getRegistryAccess() {
        return REGISTRY_ACCESS;
    }

    @Override
    public Recipe<?> getRecipeByID(RecipeManager recipeManager, ResourceLocation id) {
        return ((RecipeManagerAccessor)recipeManager).getByName().get(id);
    }

    @Override
    public RecipeHelper getHelper() {
        return RecipeHelper_1_20_1.INSTANCE;
    }

    @Override
    public void removeRecipe(RecipeManagerAccessor recipeManager, ResourceLocation id) {
        recipeManager.getByName().remove(id);
        for (Map<ResourceLocation, Recipe<?>> map : recipeManager.getByType().values()) {
            map.remove(id);
        }
    }

    public static class RecipeHelper_1_20_1
    implements RecipeHelper {
        static RecipeHelper INSTANCE = new RecipeHelper_1_20_1();

        public static IngredientAccessor getAccessor(Ingredient ingredient) {
            return (IngredientAccessor)ingredient;
        }

        public static void replaceIngredientValues(Ingredient ingredient, Ingredient.Value[] values) {
            RecipeHelper_1_20_1.getAccessor(ingredient).replaceValues(values);
        }

        @Override
        public void addAlternative(Ingredient ingredient, Item ... items) {
            Ingredient.Value[] newValues = (Ingredient.Value[])ArrayUtils.addAll((Object[])RecipeHelper_1_20_1.getAccessor(ingredient).getValues(), (Object[])((Ingredient.Value[])items));
            RecipeHelper_1_20_1.getAccessor(ingredient).replaceValues(newValues);
        }

        @Override
        public void addAlternative(Ingredient ingredient, TagKey<Item> itemTag) {
            RecipeHelper_1_20_1.replaceIngredientValues(ingredient, (Ingredient.Value[])ArrayUtils.add((Object[])RecipeHelper_1_20_1.getAccessor(ingredient).getValues(), (Object)new Ingredient.TagValue(itemTag)));
        }

        @Override
        public void addAlternative(Ingredient ingredient, Ingredient alternative) {
            RecipeHelper_1_20_1.replaceIngredientValues(ingredient, (Ingredient.Value[])ArrayUtils.addAll((Object[])RecipeHelper_1_20_1.getAccessor(ingredient).getValues(), (Object[])RecipeHelper_1_20_1.getAccessor(alternative).getValues()));
        }

        @Override
        public void removeAlternatives(Ingredient ingredient, Item ... items) {
            ArrayList<Ingredient.Value> newValues = new ArrayList<Ingredient.Value>(List.of(RecipeHelper_1_20_1.getAccessor(ingredient).getValues()));
            for (Item item : items) {
                newValues.removeIf(value -> value.m_6223_().size() == 1 && value.m_6223_().stream().findAny().orElse(ItemStack.f_41583_).m_150930_(item));
            }
            RecipeHelper_1_20_1.getAccessor(ingredient).replaceValues(newValues.toArray(new Ingredient.Value[0]));
        }

        @Override
        public void removeAlternative(Ingredient ingredient, TagKey<Item> itemTag) {
            ArrayList<Ingredient.Value> newValues = new ArrayList<Ingredient.Value>(List.of(RecipeHelper_1_20_1.getAccessor(ingredient).getValues()));
            newValues.removeIf(value -> value instanceof Ingredient.TagValue && itemTag.equals(((TagValueAccessor)value).getTag()));
            RecipeHelper_1_20_1.getAccessor(ingredient).replaceValues(newValues.toArray(new Ingredient.Value[0]));
        }

        @Override
        public void replaceIngredient(Ingredient ingredient, Ingredient newIngredient) {
            RecipeHelper_1_20_1.replaceIngredientValues(ingredient, RecipeHelper_1_20_1.getAccessor(newIngredient).getValues());
        }

        @Override
        public boolean isExactMatch(Ingredient ingredient, Item item) {
            if (ingredient.m_43947_()) {
                return false;
            }
            for (ItemStack stack : ingredient.m_43908_()) {
                if (stack.m_150930_(item)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean matchesTag(Ingredient ingredient, TagKey<Item> tag) {
            for (Ingredient.Value value : RecipeHelper_1_20_1.getAccessor(ingredient).getValues()) {
                if (!(value instanceof Ingredient.TagValue) || !((TagValueAccessor)value).getTag().equals(tag)) continue;
                return true;
            }
            return false;
        }
    }
}

