/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.player005.recipe_modification.api.IngredientSelector;
import net.player005.recipe_modification.serialization.RecipeModifierParsingException;
import org.jetbrains.annotations.Nullable;

public abstract class IngredientSelectorSerializer {
    private static final Map<String, Function<JsonObject, IngredientSelector>> deserializers = new HashMap<String, Function<JsonObject, IngredientSelector>>();

    public static IngredientSelector fromJson(@Nullable JsonElement json) {
        if (json == null) {
            throw new RecipeModifierParsingException("Missing ingredient selector. Maybe you typed \"ingredient\" instead of \"ingredients\"?");
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isNumber()) {
                return IngredientSelector.byOrdinals(primitive.getAsInt());
            }
            if (primitive.isString()) {
                return IngredientSelectorSerializer.fromString(primitive.getAsString());
            }
        }
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            ArrayList<IngredientSelector> toReturn = new ArrayList<IngredientSelector>();
            for (JsonElement jsonElement : array) {
                toReturn.add(IngredientSelectorSerializer.fromJson(jsonElement));
            }
            return IngredientSelector.and((IngredientSelector[])toReturn.toArray(IngredientSelector[]::new));
        }
        if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            Function<JsonObject, IngredientSelector> deserializer = deserializers.get(object.get("type").getAsString());
            if (deserializer == null) {
                throw new RecipeModifierParsingException("Invalid ingredient selector: unknown selector type " + object.get("type").getAsString());
            }
            return deserializer.apply(object);
        }
        throw new RecipeModifierParsingException("Invalid ingredient selector");
    }

    private static IngredientSelector fromString(String string) {
        Item item;
        if (string.startsWith("#")) {
            return IngredientSelector.matchingTag((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ResourceLocation.m_135820_((String)string.substring(1))));
        }
        boolean isStrict = string.endsWith("!");
        if (isStrict) {
            string = string.substring(0, string.length() - 1);
        }
        if ((item = (Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.m_135820_((String)string))) == Items.f_41852_) {
            throw new RecipeModifierParsingException("Invalid item: " + string);
        }
        return isStrict ? IngredientSelector.matchingItem(item) : IngredientSelector.byItem(item);
    }

    public static void registerSerializer(String name, Function<JsonObject, IngredientSelector> deserializer) {
        deserializers.put(name, deserializer);
    }

    static {
        IngredientSelectorSerializer.registerSerializer("all", json -> IngredientSelector.ALL_INGREDIENTS);
        IngredientSelectorSerializer.registerSerializer("match_item", json -> {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.m_135820_((String)json.get("item").getAsString()));
            return IngredientSelector.byItem(item);
        });
        IngredientSelectorSerializer.registerSerializer("match_item_exact", json -> {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.m_135820_((String)json.get("item").getAsString()));
            return IngredientSelector.matchingItem(item);
        });
        IngredientSelectorSerializer.registerSerializer("match_tag", json -> {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ResourceLocation.m_135820_((String)json.get("tag").getAsString()));
            return IngredientSelector.matchingTag((TagKey<Item>)tag);
        });
        IngredientSelectorSerializer.registerSerializer("from_ordinals", json -> {
            ArrayList<Integer> ordinals = new ArrayList<Integer>();
            JsonElement patt3699$temp = json.get("ordinals");
            if (patt3699$temp instanceof JsonArray) {
                JsonArray array = (JsonArray)patt3699$temp;
                for (JsonElement jsonElement : array) {
                    ordinals.add(jsonElement.getAsInt());
                }
            } else {
                JsonElement patt3872$temp = json.get("ordinal");
                if (patt3872$temp instanceof JsonPrimitive) {
                    JsonPrimitive primitive = (JsonPrimitive)patt3872$temp;
                    ordinals.add(primitive.getAsInt());
                } else {
                    throw new RecipeModifierParsingException("Invalid ordinal selector");
                }
            }
            return IngredientSelector.byOrdinals(ordinals);
        });
    }
}

