/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.player005.recipe_modification.api.RecipeFilter;
import net.player005.recipe_modification.serialization.RecipeModifierParsingException;

public abstract class RecipeFilterSerializer {
    private static final Map<String, Function<JsonObject, RecipeFilter>> deserializers = new HashMap<String, Function<JsonObject, RecipeFilter>>();
    private static final ResourceLocation CRAFTING_SHAPED = ResourceLocation.m_135820_((String)"crafting_shaped");
    private static final ResourceLocation CRAFTING_SHAPELESS = ResourceLocation.m_135820_((String)"crafting_shapeless");

    public static RecipeFilter fromJson(JsonElement json) {
        JsonPrimitive primitive;
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            return RecipeFilterSerializer.fromString(primitive.getAsString());
        }
        if (!json.isJsonObject()) {
            throw new RecipeModifierParsingException("Invalid recipe filter: expected an object");
        }
        JsonObject object = json.getAsJsonObject();
        String filterId = object.get("type").getAsString();
        if (!deserializers.containsKey(filterId)) {
            throw new RecipeModifierParsingException("Unknown recipe filter type: " + filterId);
        }
        return deserializers.get(filterId).apply(object);
    }

    private static RecipeFilter fromString(String string) {
        if (string.startsWith("!")) {
            return RecipeFilter.not(RecipeFilterSerializer.fromString(string.substring(1)));
        }
        if (string.equals("*")) {
            return RecipeFilter.ALWAYS_APPLY;
        }
        if (!string.contains(":")) {
            return RecipeFilter.namespaceEquals(string);
        }
        ResourceLocation rl = ResourceLocation.m_135820_((String)string.replace("#", ""));
        if (rl == null) {
            throw new RecipeModifierParsingException("Invalid resource location in shorthand recipe filter: " + string);
        }
        if (string.startsWith("#")) {
            return RecipeFilter.resultItemIs((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)rl));
        }
        if (BuiltInRegistries.f_257033_.m_7804_(rl)) {
            return RecipeFilter.resultItemIs((Item)BuiltInRegistries.f_257033_.m_7745_(rl));
        }
        return RecipeFilter.idEquals(rl);
    }

    private static ItemStack getItemStack(JsonElement json, Consumer<String> onError) {
        JsonObject object;
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
            return ((Item)BuiltInRegistries.f_257033_.m_7745_(RecipeFilterSerializer.getResourceLocation(json, onError))).m_7968_();
        }
        if (json instanceof JsonObject && !(object = (JsonObject)json).has("Count")) {
            return ((Item)BuiltInRegistries.f_257033_.m_7745_(RecipeFilterSerializer.getResourceLocation(object.get("id"), onError))).m_7968_();
        }
        return (ItemStack)ItemStack.f_41582_.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(true, onError);
    }

    private static ResourceLocation getResourceLocation(JsonElement json, Consumer<String> onError) {
        return (ResourceLocation)ResourceLocation.f_135803_.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(true, onError);
    }

    public static void registerSerializer(String name, Function<JsonObject, RecipeFilter> deserializer) {
        deserializers.put(name, deserializer);
    }

    static {
        RecipeFilterSerializer.registerSerializer("all_recipes", json -> RecipeFilter.ALWAYS_APPLY);
        RecipeFilterSerializer.registerSerializer("accepting_ingredient", json -> {
            ItemStack item = RecipeFilterSerializer.getItemStack(json.get("item"), err -> {
                throw new RecipeModifierParsingException("Invalid recipe filter: " + err);
            });
            return RecipeFilter.acceptsIngredient(item);
        });
        RecipeFilterSerializer.registerSerializer("result_item_is", json -> {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.m_135820_((String)json.get("item").getAsString()));
            return RecipeFilter.resultItemIs(item);
        });
        RecipeFilterSerializer.registerSerializer("id_equals", json -> {
            ResourceLocation id = ResourceLocation.m_135820_((String)json.get("id").getAsString());
            if (id == null) {
                throw new RecipeModifierParsingException("Invalid recipe filter: Invalid id: \"" + json.get("id") + "\"");
            }
            return RecipeFilter.idEquals(id);
        });
        RecipeFilterSerializer.registerSerializer("namespace_equals", json -> {
            String namespace = json.get("namespace").getAsString();
            return RecipeFilter.namespaceEquals(namespace);
        });
        RecipeFilterSerializer.registerSerializer("not", json -> {
            RecipeFilter filter = RecipeFilterSerializer.fromJson(json.get("filter"));
            return RecipeFilter.not(filter);
        });
        RecipeFilterSerializer.registerSerializer("and", json -> {
            RecipeFilter[] filters = new RecipeFilter[json.get("filters").getAsJsonArray().size()];
            for (int i = 0; i < filters.length; ++i) {
                filters[i] = RecipeFilterSerializer.fromJson(json.get("filters").getAsJsonArray().get(i));
            }
            return RecipeFilter.and(filters);
        });
        RecipeFilterSerializer.registerSerializer("or", json -> {
            RecipeFilter[] filters = new RecipeFilter[json.get("filters").getAsJsonArray().size()];
            for (int i = 0; i < filters.length; ++i) {
                filters[i] = RecipeFilterSerializer.fromJson(json.get("filters").getAsJsonArray().get(i));
            }
            return RecipeFilter.or(filters);
        });
        RecipeFilterSerializer.registerSerializer("is_recipe_type", json -> {
            ResourceLocation rl = ResourceLocation.m_135820_((String)json.get("recipe_type").getAsString());
            assert (rl != null);
            if (rl.equals((Object)CRAFTING_SHAPED)) {
                return (recipe, registries) -> recipe instanceof ShapedRecipe;
            }
            if (rl.equals((Object)CRAFTING_SHAPELESS)) {
                return (recipe, registries) -> recipe instanceof ShapelessRecipe;
            }
            RecipeType type = (RecipeType)BuiltInRegistries.f_256990_.m_7745_(rl);
            if (type == null) {
                throw new RecipeModifierParsingException("Unknown recipe type: " + rl);
            }
            return RecipeFilter.isType(type);
        });
        RecipeFilterSerializer.registerSerializer("result_item_predicate", json -> {
            ItemPredicate predicate = ItemPredicate.m_45051_((JsonElement)json.get("predicate"));
            return RecipeFilter.resultItemMatches(predicate);
        });
    }
}

