/*
 * Decompiled with CFR 0.152.
 */
package cn.nutminds.eidolonedoni.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class HeartTerrineBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty BITES = IntegerProperty.create((String)"bites", (int)0, (int)3);
    protected static final VoxelShape SHAPE_NS = Block.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)10.0, (double)15.0);
    protected static final VoxelShape SHAPE_WE = Block.box((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)10.0, (double)13.0);
    public final Supplier<Item> heartTerrineSlice;

    public HeartTerrineBlock(BlockBehaviour.Properties properties, Supplier<Item> heartTerrineSlice) {
        super(properties);
        this.heartTerrineSlice = heartTerrineSlice;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getHeartTerrineSliceItem() {
        return new ItemStack((ItemLike)this.heartTerrineSlice.get());
    }

    public int getMaxBites() {
        return 4;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return direction == Direction.NORTH || direction == Direction.SOUTH ? SHAPE_NS : SHAPE_WE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (heldStack.is(ModTags.KNIVES)) {
            return this.cutSlice(level, pos, state, player);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            if (this.consumeBite(level, pos, state, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.consumeBite(level, pos, state, player);
    }

    protected InteractionResult consumeBite(Level level, BlockPos pos, BlockState state, Player playerIn) {
        int bites;
        if (!playerIn.canEat(false)) {
            return InteractionResult.PASS;
        }
        ItemStack sliceStack = this.getHeartTerrineSliceItem();
        FoodProperties sliceFood = sliceStack.getItem().getFoodProperties(sliceStack, (LivingEntity)playerIn);
        if (sliceFood != null) {
            playerIn.getFoodData().eat(sliceFood);
            for (FoodProperties.PossibleEffect effect : sliceFood.effects()) {
                if (level.isClientSide || effect == null || !(level.random.nextFloat() < effect.probability())) continue;
                playerIn.addEffect(effect.effect());
            }
        }
        if ((bites = ((Integer)state.getValue((Property)BITES)).intValue()) < this.getMaxBites() - 1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.removeBlock(pos, false);
        }
        level.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Player player) {
        int bites = (Integer)state.getValue((Property)BITES);
        if (bites < this.getMaxBites() - 1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.removeBlock(pos, false);
        }
        Direction direction = player.getDirection().getOpposite();
        ItemUtils.spawnItemEntity((Level)level, (ItemStack)this.getHeartTerrineSliceItem(), (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.3), (double)((double)pos.getZ() + 0.5), (double)((double)direction.getStepX() * 0.15), (double)0.05, (double)((double)direction.getStepZ() * 0.15));
        level.playSound(null, pos, SoundEvents.WOOL_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
        return ItemInteractionResult.SUCCESS;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, BITES});
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return this.getMaxBites() - (Integer)blockState.getValue((Property)BITES);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

