/*
 * Decompiled with CFR 0.152.
 */
package cn.nutminds.eidolonedoni.block;

import cn.nutminds.eidolonedoni.block.AvennianSprigBaleBlock;
import cn.nutminds.eidolonedoni.registry.EEItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class RoastedAvennianSprigBaleBlock
extends AvennianSprigBaleBlock {
    public static final IntegerProperty STAGE = IntegerProperty.create((String)"stage", (int)0, (int)3);
    protected static final VoxelShape SHAPE_UD_1 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SHAPE_UD_2 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape SHAPE_UD_3 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    protected static final VoxelShape SHAPE_N_1 = Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_N_2 = Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_N_3 = Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_S_1 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_S_2 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SHAPE_S_3 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    protected static final VoxelShape SHAPE_W_1 = Block.box((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_W_2 = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_W_3 = Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_E_1 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_E_2 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_E_3 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        if (direction == Direction.UP || direction == Direction.DOWN) {
            if ((Integer)state.getValue((Property)STAGE) == 1) {
                return SHAPE_UD_1;
            }
            if ((Integer)state.getValue((Property)STAGE) == 2) {
                return SHAPE_UD_2;
            }
            if ((Integer)state.getValue((Property)STAGE) == 3) {
                return SHAPE_UD_3;
            }
        }
        if (direction == Direction.NORTH) {
            if ((Integer)state.getValue((Property)STAGE) == 1) {
                return SHAPE_N_1;
            }
            if ((Integer)state.getValue((Property)STAGE) == 2) {
                return SHAPE_N_2;
            }
            if ((Integer)state.getValue((Property)STAGE) == 3) {
                return SHAPE_N_3;
            }
        }
        if (direction == Direction.SOUTH) {
            if ((Integer)state.getValue((Property)STAGE) == 1) {
                return SHAPE_S_1;
            }
            if ((Integer)state.getValue((Property)STAGE) == 2) {
                return SHAPE_S_2;
            }
            if ((Integer)state.getValue((Property)STAGE) == 3) {
                return SHAPE_S_3;
            }
        }
        if (direction == Direction.WEST) {
            if ((Integer)state.getValue((Property)STAGE) == 1) {
                return SHAPE_W_1;
            }
            if ((Integer)state.getValue((Property)STAGE) == 2) {
                return SHAPE_W_2;
            }
            if ((Integer)state.getValue((Property)STAGE) == 3) {
                return SHAPE_W_3;
            }
        }
        if (direction == Direction.EAST) {
            if ((Integer)state.getValue((Property)STAGE) == 1) {
                return SHAPE_E_1;
            }
            if ((Integer)state.getValue((Property)STAGE) == 2) {
                return SHAPE_E_2;
            }
            if ((Integer)state.getValue((Property)STAGE) == 3) {
                return SHAPE_E_3;
            }
        }
        return Shapes.block();
    }

    public RoastedAvennianSprigBaleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (heldStack.is(Items.STICK)) {
            return this.takeServing(level, pos, state, player);
        }
        player.displayClientMessage((Component)Component.translatable((String)"eidolon_edoni.block.roasted_avennian_sprig_bale.use_container"), true);
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected ItemInteractionResult takeServing(Level level, BlockPos pos, BlockState state, Player player) {
        int bites = (Integer)state.getValue((Property)STAGE);
        if (bites < 3) {
            level.setBlock(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.removeBlock(pos, false);
        }
        Direction direction = player.getDirection().getOpposite();
        ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)EEItems.ROASTED_AVENNIAN_SPRIG.get()), (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.3), (double)((double)pos.getZ() + 0.5), (double)((double)direction.getStepX() * 0.15), (double)0.05, (double)((double)direction.getStepZ() * 0.15));
        level.playSound(null, pos, SoundEvents.GRASS_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, STAGE});
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

