/*
 * Decompiled with CFR 0.152.
 */
package cn.nutminds.eidolonedoni.incense;

import alexthw.eidolon_repraised.api.ritual.IncenseRitual;
import alexthw.eidolon_repraised.client.particle.Particles;
import cn.nutminds.eidolonedoni.EidolonEdoni;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class GluttonyIncense
extends IncenseRitual {
    public static final TagKey<MobEffect> GLUTTONY_INCENSE_WHITELIST = GluttonyIncense.create("gluttony_incense_whitelist");

    public GluttonyIncense(ResourceLocation registryName) {
        super(36000, registryName);
    }

    public float getRed() {
        return 0.7294118f;
    }

    public float getGreen() {
        return 0.60784316f;
    }

    public float getBlue() {
        return 0.7294118f;
    }

    private static TagKey<MobEffect> create(String string) {
        return TagKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)EidolonEdoni.modid(string));
    }

    public void tickEffect(int age) {
        if (age % 10 == 0) {
            Level level = this.censer.getLevel();
            BlockPos pos = this.censer.getBlockPos();
            assert (level != null);
            for (LivingEntity entity : level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate((double)this.range()))) {
                Player player;
                entity.getActiveEffects().removeIf(effect -> effect.getEffect().is(GLUTTONY_INCENSE_WHITELIST) && !effect.getCures().isEmpty());
                if (!(entity instanceof Player) || (player = (Player)entity).getFoodData().needsFood()) continue;
                player.getFoodData().setFoodLevel(player.getFoodData().getFoodLevel() - 1);
            }
        }
    }

    public void animateParticles(int burnCounter, BlockPos blockPos, Level level) {
        super.animateParticles(burnCounter, blockPos, level);
        double x = blockPos.getX();
        double y = blockPos.getY() + 1;
        double z = blockPos.getZ();
        if (level.random.nextInt(4) == 0) {
            for (int i = 0; i < 5; ++i) {
                Particles.spawnParticle((Level)level, (ParticleOptions)ParticleTypes.FALLING_NECTAR, (double)x, (double)(y - 0.5), (double)z, (double)0.0, (double)0.0, (double)0.0, (double)this.range(), (double)0.0, (double)this.range());
            }
        }
    }
}

