/*
 * Decompiled with CFR 0.152.
 */
package cn.nutminds.eidolonedoni.incense;

import alexthw.eidolon_repraised.api.ritual.IncenseRitual;
import alexthw.eidolon_repraised.client.particle.Particles;
import alexthw.eidolon_repraised.registries.EidolonParticles;
import cn.nutminds.eidolonedoni.registry.EEEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class StimulatingIncense
extends IncenseRitual {
    public StimulatingIncense(ResourceLocation registryName) {
        super(6000, registryName);
    }

    public void tickEffect(int age) {
        if (age % 20 == 0) {
            Level level = this.censer.getLevel();
            BlockPos pos = this.censer.getBlockPos();
            assert (level != null);
            for (LivingEntity entity : level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate((double)this.range()))) {
                entity.addEffect(new MobEffectInstance(EEEffects.EXCITED, 6000, 1));
                entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 6000, 1));
            }
        }
    }

    public float getRed() {
        return 1.0f;
    }

    public float getGreen() {
        return 0.0f;
    }

    public float getBlue() {
        return 0.0f;
    }

    public void animateParticles(int burnCounter, BlockPos blockPos, Level level) {
        super.animateParticles(burnCounter, blockPos, level);
        double x = blockPos.getX();
        double y = blockPos.getY() + 1;
        double z = blockPos.getZ();
        if (level.random.nextInt(4) == 0) {
            for (int i = 0; i < 5; ++i) {
                Particles.spawnParticle((Level)level, (ParticleOptions)ParticleTypes.CRIMSON_SPORE, (double)x, (double)(y - 0.5), (double)z, (double)0.0, (double)-0.01, (double)0.0, (double)this.range(), (double)0.0, (double)this.range());
            }
            Particles.create((ParticleType)((ParticleType)EidolonParticles.SMOKE_PARTICLE.get())).setAlpha(0.35f, 0.0f).setScale(0.375f, 0.125f).setLifetime(80).randomOffset((double)this.range() * 0.75, 0.1).randomVelocity((double)0.025f, (double)0.025f).addVelocity(0.0, (double)-0.0125f, 0.0).setColor(1.0f, 0.0f, 0.0f, 0.75f, 0.1f, 0.1f).repeat(level, x, y + 0.125, z, 5);
        }
    }
}

