/*
 * Decompiled with CFR 0.152.
 */
package cn.nutminds.eidolonedoni.item;

import alexthw.eidolon_repraised.registries.EidolonPotions;
import cn.nutminds.eidolonedoni.registry.EEItems;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.MathUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

@EventBusSubscriber(modid="eidolon_edoni")
public class DarkFeedItem
extends Item {
    public static final List<MobEffectInstance> EFFECTS = Lists.newArrayList((Object[])new MobEffectInstance[]{new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 6000, 3), new MobEffectInstance(MobEffects.JUMP, 6000, 1)});

    public DarkFeedItem(Item.Properties properties) {
        super(properties);
    }

    @SubscribeEvent
    public static void onDarkFeedApplied(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        Entity target = event.getTarget();
        ItemStack heldStack = event.getItemStack();
        if (target instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)target;
            if (target.getType().is(ModTags.HORSE_FEED_USERS)) {
                boolean isTameable = entity instanceof AbstractHorse;
                if (entity.isAlive() && (!isTameable || ((AbstractHorse)entity).isTamed()) && heldStack.getItem().equals(EEItems.DARK_FEED.get())) {
                    entity.setHealth(entity.getMaxHealth());
                    if (entity.getType().is(EntityTypeTags.UNDEAD) || entity.hasEffect((Holder)EidolonPotions.UNDEATH_EFFECT)) {
                        for (MobEffectInstance effect : EFFECTS) {
                            entity.addEffect(new MobEffectInstance(effect));
                        }
                        for (int i = 0; i < 5; ++i) {
                            double d0 = MathUtils.RAND.nextGaussian() * 0.02;
                            double d1 = MathUtils.RAND.nextGaussian() * 0.02;
                            double d2 = MathUtils.RAND.nextGaussian() * 0.02;
                            entity.level().addParticle((ParticleOptions)ModParticleTypes.STAR.get(), entity.getRandomX(1.0), entity.getRandomY() + 0.5, entity.getRandomZ(1.0), d0, d1, d2);
                        }
                    } else {
                        entity.addEffect(new MobEffectInstance((Holder)EidolonPotions.UNDEATH_EFFECT, -1));
                        for (int i = 0; i < 5; ++i) {
                            double d0 = MathUtils.RAND.nextGaussian() * 0.02;
                            double d1 = MathUtils.RAND.nextGaussian() * 0.02;
                            double d2 = MathUtils.RAND.nextGaussian() * 0.02;
                            entity.level().addParticle((ParticleOptions)ParticleTypes.RAID_OMEN, entity.getRandomX(1.0), entity.getRandomY() + 0.5, entity.getRandomZ(1.0), d0, d1, d2);
                        }
                        entity.level().playSound(null, target.blockPosition(), SoundEvents.ZOMBIE_VILLAGER_CONVERTED, SoundSource.PLAYERS, 0.8f, 0.8f);
                    }
                    entity.level().playSound(null, target.blockPosition(), SoundEvents.HORSE_EAT, SoundSource.PLAYERS, 0.8f, 0.8f);
                    if (!player.isCreative()) {
                        heldStack.shrink(1);
                    }
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                }
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (!((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            return;
        }
        tooltip.add((Component)TextUtils.getTranslation((String)"tooltip.dark_feed.when_feeding_undead", (Object[])new Object[0]).withStyle(ChatFormatting.GRAY));
        for (MobEffectInstance effectInstance : EFFECTS) {
            MutableComponent undeadEffectDescription = Component.literal((String)" ");
            undeadEffectDescription.append((Component)Component.translatable((String)effectInstance.getDescriptionId()));
            MobEffect effect = (MobEffect)effectInstance.getEffect().value();
            if (effectInstance.getAmplifier() > 0) {
                undeadEffectDescription.append(" ").append((Component)Component.translatable((String)("potion.potency." + effectInstance.getAmplifier())));
            }
            if (effectInstance.getDuration() > 20) {
                undeadEffectDescription.append(" (").append(MobEffectUtil.formatDuration((MobEffectInstance)effectInstance, (float)1.0f, (float)context.tickRate())).append(")");
            }
            tooltip.add((Component)undeadEffectDescription.withStyle(((MobEffect)effectInstance.getEffect().value()).getCategory().getTooltipFormatting()));
        }
        tooltip.add((Component)Component.empty());
        MobEffectInstance undeathInstance = new MobEffectInstance((Holder)EidolonPotions.UNDEATH_EFFECT, -1);
        tooltip.add((Component)TextUtils.getTranslation((String)"tooltip.dark_feed.when_feeding_else", (Object[])new Object[0]).withStyle(ChatFormatting.GRAY));
        MutableComponent elseEffectDescription = Component.literal((String)" ");
        elseEffectDescription.append((Component)Component.translatable((String)undeathInstance.getDescriptionId()));
        elseEffectDescription.append(" ").append((Component)Component.translatable((String)("potion.potency." + undeathInstance.getAmplifier())));
        elseEffectDescription.append(" (").append(MobEffectUtil.formatDuration((MobEffectInstance)undeathInstance, (float)1.0f, (float)context.tickRate())).append(")");
        tooltip.add((Component)elseEffectDescription.withStyle(((MobEffect)undeathInstance.getEffect().value()).getCategory().getTooltipFormatting()));
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        Horse horse;
        if (target instanceof Horse && (horse = (Horse)target).isAlive() && horse.isTamed()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

