/*
 * Decompiled with CFR 0.152.
 */
package cn.nutminds.eidolonedoni.item;

import cn.nutminds.eidolonedoni.registry.EEEffects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import vectorwing.farmersdelight.common.item.ConsumableItem;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.utility.MathUtils;

public class JockeyPieSliceItem
extends ConsumableItem {
    public static final TagKey<EntityType<?>> JOCKEY_PIE_USERS = JockeyPieSliceItem.create("jockey_pie_users");

    public JockeyPieSliceItem(Item.Properties properties) {
        super(properties);
    }

    private static TagKey<EntityType<?>> create(String path) {
        return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eidolon_edoni", (String)path));
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
        LivingEntity entity;
        Entity vehicle;
        if (consumer.isPassenger() && (vehicle = consumer.getVehicle()) instanceof LivingEntity && (entity = (LivingEntity)vehicle).isAlive()) {
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 600, 1));
            entity.addEffect(new MobEffectInstance(EEEffects.REANIMATE, 600, 1));
            for (int i = 0; i < 5; ++i) {
                double xSpeed = MathUtils.RAND.nextGaussian() * 0.02;
                double ySpeed = MathUtils.RAND.nextGaussian() * 0.02;
                double zSpeed = MathUtils.RAND.nextGaussian() * 0.02;
                entity.level().addParticle((ParticleOptions)ModParticleTypes.STAR.get(), entity.getRandomX(1.0), entity.getRandomY() + 0.5, entity.getRandomZ(1.0), xSpeed, ySpeed, zSpeed);
            }
        }
    }
}

