/*
 * Decompiled with CFR 0.152.
 */
package cn.nutminds.eidolonedoni;

import alexthw.eidolon_repraised.registries.IncenseRegistry;
import cn.nutminds.eidolonedoni.EEConfig;
import cn.nutminds.eidolonedoni.incense.ChorusIncense;
import cn.nutminds.eidolonedoni.incense.GluttonyIncense;
import cn.nutminds.eidolonedoni.incense.RelaxingIncense;
import cn.nutminds.eidolonedoni.incense.StimulatingIncense;
import cn.nutminds.eidolonedoni.item.AllRounderItem;
import cn.nutminds.eidolonedoni.registry.EEBlockEntityTypes;
import cn.nutminds.eidolonedoni.registry.EEBlocks;
import cn.nutminds.eidolonedoni.registry.EECreativeTab;
import cn.nutminds.eidolonedoni.registry.EEEffects;
import cn.nutminds.eidolonedoni.registry.EEItems;
import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.slf4j.Logger;

@Mod(value="eidolon_edoni")
public class EidolonEdoni {
    public static final String MODID = "eidolon_edoni";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation RELAXING_INCENSE = ResourceLocation.fromNamespaceAndPath((String)"eidolon_edoni", (String)"relaxing_incense");
    public static final ResourceLocation CHORUS_INCENSE = ResourceLocation.fromNamespaceAndPath((String)"eidolon_edoni", (String)"chorus_incense");
    public static final ResourceLocation STIMULATING_INCENSE = ResourceLocation.fromNamespaceAndPath((String)"eidolon_edoni", (String)"stimulating_incense");
    public static final ResourceLocation GLUTTONY_INCENSE = ResourceLocation.fromNamespaceAndPath((String)"eidolon_edoni", (String)"gluttony_incense");

    public EidolonEdoni(IEventBus modBus, ModContainer container) {
        modBus.addListener(this::setup);
        EEItems.ITEMS.register(modBus);
        EEBlocks.BLOCKS.register(modBus);
        EEBlockEntityTypes.BLOCK_ENTITIES.register(modBus);
        EECreativeTab.CREATIVE_MODE_TAB.register(modBus);
        EEEffects.EFFECTS.register(modBus);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)EEConfig.SPEC);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            AllRounderItem.initHarvestables();
            IncenseRegistry.register((Item)EEItems.RELAXING_INCENSE.get(), (ResourceLocation)RELAXING_INCENSE, () -> new RelaxingIncense(RELAXING_INCENSE));
            IncenseRegistry.register((Item)EEItems.CHORUS_INCENSE.get(), (ResourceLocation)CHORUS_INCENSE, () -> new ChorusIncense(CHORUS_INCENSE));
            IncenseRegistry.register((Item)EEItems.STIMULATING_INCENSE.get(), (ResourceLocation)STIMULATING_INCENSE, () -> new StimulatingIncense(STIMULATING_INCENSE));
            IncenseRegistry.register((Item)EEItems.GLUTTONY_INCENSE.get(), (ResourceLocation)GLUTTONY_INCENSE, () -> new GluttonyIncense(GLUTTONY_INCENSE));
        });
    }

    public static ResourceLocation modid(String string) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)string);
    }
}

