/*
 * Decompiled with CFR 0.152.
 */
package cn.nutminds.eidolonedoni.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.ScheduledTick;
import vectorwing.farmersdelight.common.tag.ModTags;

public class AvennianSprigBaleBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;

    public AvennianSprigBaleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    public void scheduleTick(ServerLevel level, BlockPos pos) {
        BlockState belowState;
        if (!level.isClientSide) {
            // empty if block
        }
        if ((belowState = level.getBlockState(pos.below())).is(ModTags.HEAT_SOURCES) || belowState.is(ModTags.HEAT_CONDUCTORS)) {
            // empty if block
        }
        level.scheduleTick(pos, (Block)this, 600);
    }

    public void tick(ServerLevel level, BlockPos pos, ScheduledTick scheduledTick) {
    }

    public float getJumpFactor() {
        return 0.5f;
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.causeFallDamage(fallDistance, 0.2f, level.damageSources().fall());
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 20;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

