/*
 * Decompiled with CFR 0.152.
 */
package cn.nutminds.eidolonedoni.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.block.FeastBlock;

public class CurryPotBlock
extends FeastBlock {
    public final Supplier<Item> servingItem;
    public final Supplier<Item> altServingItem;
    public final Supplier<Item> containerItem;
    public final Supplier<Item> altContainerItem;
    protected static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);

    public CurryPotBlock(BlockBehaviour.Properties properties, Supplier<Item> containerItem, Supplier<Item> altContainerItem, Supplier<Item> servingItem, Supplier<Item> altServingItem, boolean hasLeftovers) {
        super(properties, servingItem, hasLeftovers);
        this.servingItem = servingItem;
        this.altServingItem = altServingItem;
        this.containerItem = containerItem;
        this.altContainerItem = altContainerItem;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public ItemStack getServingItem(BlockState state) {
        return new ItemStack((ItemLike)this.servingItem.get());
    }

    public ItemStack getAltServingItem(BlockState state) {
        return new ItemStack((ItemLike)this.altServingItem.get());
    }

    protected ItemInteractionResult takeServing(LevelAccessor level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int servings = (Integer)state.getValue((Property)this.getServingsProperty());
        if (servings == 0) {
            level.playSound(null, pos, SoundEvents.LANTERN_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
            level.destroyBlock(pos, true);
            return ItemInteractionResult.SUCCESS;
        }
        ItemStack serving = this.getServingItem(state);
        ItemStack altServing = this.getAltServingItem(state);
        ItemStack heldStack = player.getItemInHand(hand);
        if (servings > 0) {
            if (ItemStack.isSameItem((ItemStack)heldStack, (ItemStack)this.containerItem.get().getDefaultInstance())) {
                level.setBlock(pos, (BlockState)state.setValue((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(servings - 1)), 3);
                if (!player.getAbilities().instabuild) {
                    heldStack.shrink(1);
                }
                if (!player.getInventory().add(serving)) {
                    player.drop(serving, false);
                }
                if ((Integer)level.getBlockState(pos).getValue((Property)this.getServingsProperty()) == 0 && !this.hasLeftovers) {
                    level.removeBlock(pos, false);
                }
                level.playSound(null, pos, (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
            if (ItemStack.isSameItem((ItemStack)heldStack, (ItemStack)this.altContainerItem.get().getDefaultInstance())) {
                level.setBlock(pos, (BlockState)state.setValue((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(servings - 1)), 3);
                if (!player.getAbilities().instabuild) {
                    heldStack.shrink(1);
                }
                if (!player.getInventory().add(altServing)) {
                    player.drop(serving, false);
                }
                if ((Integer)level.getBlockState(pos).getValue((Property)this.getServingsProperty()) == 0 && !this.hasLeftovers) {
                    level.removeBlock(pos, false);
                }
                level.playSound(null, pos, (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
            player.displayClientMessage((Component)Component.translatable((String)"eidolon_edoni.block.curry_pot.use_container"), true);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

