/*
 * Decompiled with CFR 0.152.
 */
package cn.nutminds.eidolonedoni.block;

import cn.nutminds.eidolonedoni.registry.EEEffects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import vectorwing.farmersdelight.common.block.PieBlock;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.utility.MathUtils;

public class JockeyPieBlock
extends PieBlock {
    public JockeyPieBlock(BlockBehaviour.Properties properties, Supplier<Item> pieSlice) {
        super(properties, pieSlice);
    }

    protected InteractionResult consumeBite(Level level, BlockPos pos, BlockState state, Player playerIn) {
        int bites;
        LivingEntity entity;
        Entity vehicle;
        if (!playerIn.canEat(false)) {
            return InteractionResult.PASS;
        }
        ItemStack sliceStack = this.getPieSliceItem();
        FoodProperties sliceFood = sliceStack.getItem().getFoodProperties(sliceStack, (LivingEntity)playerIn);
        if (sliceFood != null) {
            playerIn.getFoodData().eat(sliceFood);
            for (FoodProperties.PossibleEffect effect : sliceFood.effects()) {
                if (level.isClientSide || effect == null || !(level.random.nextFloat() < effect.probability())) continue;
                playerIn.addEffect(effect.effect());
            }
        }
        if (playerIn.isPassenger() && (vehicle = playerIn.getVehicle()) instanceof LivingEntity && (entity = (LivingEntity)vehicle).isAlive()) {
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 600, 1));
            entity.addEffect(new MobEffectInstance(EEEffects.REANIMATE, 600, 1));
            for (int i = 0; i < 5; ++i) {
                double xSpeed = MathUtils.RAND.nextGaussian() * 0.02;
                double ySpeed = MathUtils.RAND.nextGaussian() * 0.02;
                double zSpeed = MathUtils.RAND.nextGaussian() * 0.02;
                entity.level().addParticle((ParticleOptions)ModParticleTypes.STAR.get(), entity.getRandomX(1.0), entity.getRandomY() + 0.5, entity.getRandomZ(1.0), xSpeed, ySpeed, zSpeed);
            }
        }
        if ((bites = ((Integer)state.getValue((Property)BITES)).intValue()) < this.getMaxBites() - 1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.removeBlock(pos, false);
        }
        level.playSound((Player)null, pos, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }
}

