/*
 * Decompiled with CFR 0.152.
 */
package cn.nutminds.eidolonedoni.event;

import alexthw.eidolon_repraised.registries.Registry;
import cn.nutminds.eidolonedoni.client.ElderStoveRenderer;
import cn.nutminds.eidolonedoni.registry.EEBlockEntityTypes;
import cn.nutminds.eidolonedoni.registry.EEItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="eidolon_edoni", value={Dist.CLIENT})
public class EEClientEvents {
    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(EEBlockEntityTypes.STOVE.get(), ElderStoveRenderer::new);
    }

    @SubscribeEvent
    public static void onTooltipEvent(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        CustomData blockEntityData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        List tooltip = event.getToolTip();
        if (stack.is(((Block)Registry.GOBLET.get()).asItem()) && blockEntityData != null) {
            CompoundTag compoundTag = blockEntityData.copyTag();
            ResourceLocation entityId = ResourceLocation.tryParse((String)compoundTag.getString("type"));
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityId);
            if (compoundTag.getString("type").equals("minecraft:villager")) {
                tooltip.add(1, Component.translatable((String)entityType.toString()).withStyle(ChatFormatting.DARK_RED));
            } else {
                tooltip.add(1, Component.translatable((String)entityType.toString()).withStyle(ChatFormatting.DARK_PURPLE));
            }
        }
        if (stack.is((Holder)Registry.RED_CANDY) || stack.is((Holder)Registry.GRAPE_CANDY) || stack.is(EEItems.CHERRY_CANDY.get())) {
            for (FoodProperties.PossibleEffect effect : stack.getFoodProperties((LivingEntity)event.getEntity()).effects()) {
                MobEffectInstance effectInstance = effect.effect();
                MutableComponent effectText = Component.translatable((String)effectInstance.getDescriptionId());
                Player player = event.getEntity();
                if (effectInstance.getDuration() > 20) {
                    effectText = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{effectText, MobEffectUtil.formatDuration((MobEffectInstance)effectInstance, (float)1.0f, (float)(player == null ? 20.0f : player.level().tickRateManager().tickrate()))});
                }
                tooltip.add(effectText.withStyle(((MobEffect)effectInstance.getEffect().value()).getCategory().getTooltipFormatting()));
            }
        }
    }
}

