/*
 * Decompiled with CFR 0.152.
 */
package cn.nutminds.eidolonedoni.event;

import alexthw.eidolon_repraised.common.entity.WraithEntity;
import alexthw.eidolon_repraised.registries.EidolonPotions;
import alexthw.eidolon_repraised.registries.Registry;
import cn.nutminds.eidolonedoni.EEConfig;
import cn.nutminds.eidolonedoni.EidolonEdoni;
import cn.nutminds.eidolonedoni.registry.EEEffects;
import cn.nutminds.eidolonedoni.registry.EEItems;
import java.util.Calendar;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="eidolon_edoni")
public class EEServerEvents {
    public static final TagKey<EntityType<?>> IMMUNE_TO_FETTERED = EEServerEvents.create("immune_to_fettered");

    private static TagKey<EntityType<?>> create(String string) {
        return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)EidolonEdoni.modid(string));
    }

    @SubscribeEvent
    static void onLivingDamageEvent(LivingDamageEvent.Post event) {
        Entity entity = event.getSource().getDirectEntity();
        if (entity instanceof LivingEntity) {
            int amplifier;
            MobEffectInstance instance;
            LivingEntity source = (LivingEntity)entity;
            if (event.getEntity().hasEffect(EEEffects.SOULTAKING) && (instance = event.getEntity().getEffect(EEEffects.SOULTAKING)) != null) {
                amplifier = instance.getAmplifier();
                source.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, (Integer)EEConfig.SOULTAKING_WEAKNESS_DURATION_BASE.get() * (amplifier + 1), 1));
                source.addEffect(new MobEffectInstance((Holder)EidolonPotions.VULNERABLE_EFFECT, (Integer)EEConfig.SOULTAKING_VULNERABLE_DURATION_BASE.get() * (amplifier + 1), amplifier + 1));
            }
            if (source.hasEffect(EEEffects.CLINGING) && (instance = source.getEffect(EEEffects.CLINGING)) != null) {
                amplifier = instance.getAmplifier();
                if (!event.getEntity().getType().is(IMMUNE_TO_FETTERED)) {
                    event.getEntity().addEffect(new MobEffectInstance(EEEffects.FETTERED, (Integer)EEConfig.CLINGING_FETTERED_DURATION_BASE.get() * (amplifier + 1)));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onMobSpawnEvent(FinalizeSpawnEvent event) {
        Player player;
        Mob mob = event.getEntity();
        MobSpawnType type = event.getSpawnType();
        if (mob instanceof Enemy && (type == MobSpawnType.NATURAL || type == MobSpawnType.PATROL || type == MobSpawnType.REINFORCEMENT || type == MobSpawnType.JOCKEY) && (player = event.getLevel().getNearestPlayer(event.getX(), event.getY(), event.getZ(), 64.0, true)) != null && player.hasEffect(EEEffects.FAITHFUL)) {
            MobEffectInstance instance = player.getEffect(EEEffects.FAITHFUL);
            double distance = mob.distanceTo((Entity)player);
            if (instance != null && distance <= (double)(24 + 8 * (instance.getAmplifier() + 1))) {
                event.setSpawnCancelled(true);
            }
        }
    }

    @SubscribeEvent
    static void onIncomingDamage(LivingIncomingDamageEvent event) {
        MobEffectInstance instance;
        if (event.getEntity().hasEffect(EEEffects.EXCITED) && (instance = event.getEntity().getEffect(EEEffects.EXCITED)) != null && event.getOriginalAmount() >= 0.0f) {
            event.setAmount(event.getOriginalAmount() + event.getOriginalAmount() * (float)(instance.getAmplifier() + 1));
        }
    }

    @SubscribeEvent
    static void onEntityTickPre(EntityTickEvent.Pre event) {
        LivingEntity livingEntity;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).hasEffect(EEEffects.FETTERED)) {
            Vec3 deltaMovement = entity.getDeltaMovement();
            entity.setDeltaMovement(deltaMovement.x * 0.0, deltaMovement.y * 0.0, deltaMovement.z * 0.0);
        }
    }

    @SubscribeEvent
    static void onMobKilled(LivingDeathEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        Entity source = event.getSource().getDirectEntity();
        if (source instanceof Player && (player = (Player)source).getItemInHand(InteractionHand.MAIN_HAND).is(EEItems.ALL_ROUNDER)) {
            Inventory inventory = player.getInventory();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack itemStack = inventory.getItem(i);
                if (!itemStack.is(((Block)Registry.GOBLET.get()).asItem()) || itemStack.has(DataComponents.BLOCK_ENTITY_DATA) || entity instanceof Monster) continue;
                ItemStack filledGoblet = EEServerEvents.createFilledGoblet((Entity)entity);
                player.addItem(filledGoblet);
                if (player.hasInfiniteMaterials()) continue;
                itemStack.shrink(1);
            }
        }
    }

    public static ItemStack createFilledGoblet(Entity entity) {
        ItemStack filledGoblet = new ItemStack((ItemLike)((Block)Registry.GOBLET.get()).asItem());
        CompoundTag blockEntityData = new CompoundTag();
        blockEntityData.putString("type", EntityType.getKey((EntityType)entity.getType()).toString());
        BlockItem.setBlockEntityData((ItemStack)filledGoblet, (BlockEntityType)((BlockEntityType)Registry.GOBLET_TILE_ENTITY.get()), (CompoundTag)blockEntityData);
        return filledGoblet;
    }

    @SubscribeEvent
    public static void onDrop(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        if (event.getSource().getEntity() instanceof Player && !entity.level().isClientSide()) {
            Calendar calendar = Calendar.getInstance();
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            if ((month == 10 && day >= 28 || month == 11 && day <= 2) && entity.level().random.nextInt(10) == 0 && entity instanceof WraithEntity) {
                event.getDrops().add(new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)EEItems.CHERRY_CANDY.get())));
            }
        }
    }
}

