/*
 * Decompiled with CFR 0.152.
 */
package cn.nutminds.eidolonedoni.item;

import alexthw.eidolon_repraised.api.capability.IReputation;
import alexthw.eidolon_repraised.common.block.HerbBlockBase;
import alexthw.eidolon_repraised.common.deity.Deities;
import alexthw.eidolon_repraised.common.item.AthameItem;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import alexthw.eidolon_repraised.registries.EidolonDataComponents;
import alexthw.eidolon_repraised.registries.EidolonRecipes;
import alexthw.eidolon_repraised.registries.Registry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.enchanting.GetEnchantmentLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.item.KnifeItem;
import vectorwing.farmersdelight.common.tag.ModTags;

public class AllRounderItem
extends KnifeItem {
    public static final Map<Block, ItemStack> harvestables = new HashMap<Block, ItemStack>();

    public AllRounderItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLooting(GetEnchantmentLevelEvent event) {
        if (event.getStack().getItem() instanceof AllRounderItem && event.isTargetting(Enchantments.LOOTING)) {
            ItemEnchantments.Mutable mutable = event.getEnchantments();
            event.getHolder(Enchantments.LOOTING).ifPresent(enchantment -> mutable.upgrade((Holder)enchantment, mutable.getLevel((Holder)enchantment) * 2 + 1));
        }
    }

    @SubscribeEvent
    public void onHurt(LivingDamageEvent.Pre event) {
        block4: {
            block3: {
                block2: {
                    LivingEntity living;
                    Entity entity = event.getSource().getEntity();
                    if (!(entity instanceof LivingEntity) || !((entity = (living = (LivingEntity)entity).getMainHandItem().getItem()) instanceof AllRounderItem)) break block2;
                    AllRounderItem allRounderItem = (AllRounderItem)entity;
                    if (event.getEntity() instanceof EnderMan) break block3;
                }
                if (!(event.getEntity() instanceof Endermite) && !(event.getEntity() instanceof EnderDragon)) break block4;
            }
            event.setNewDamage(event.getNewDamage() * 4.0f);
        }
    }

    @SubscribeEvent
    public void onTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            int persistent;
            IReputation reputation;
            ItemStack stack = inventory.getItem(i);
            if (!stack.is((Item)this) || (reputation = (IReputation)player.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY)) == null) continue;
            double darkReputation = reputation.getReputation(Deities.DARK_DEITY.getId());
            double lightReputation = reputation.getReputation(Deities.LIGHT_DEITY.getId());
            if (stack.has((Supplier)EidolonDataComponents.NECROTIC)) {
                persistent = (Integer)stack.getOrDefault((Supplier)EidolonDataComponents.NECROTIC, (Object)0);
                if (darkReputation >= lightReputation && darkReputation != 0.0 && persistent <= 50) {
                    stack.set((Supplier)EidolonDataComponents.NECROTIC, (Object)51);
                }
                if (darkReputation < lightReputation && persistent > 50) {
                    stack.remove((Supplier)EidolonDataComponents.NECROTIC);
                }
            } else if (darkReputation >= lightReputation && darkReputation != 0.0) {
                stack.set((Supplier)EidolonDataComponents.NECROTIC, (Object)51);
            }
            if (stack.has((Supplier)EidolonDataComponents.CONSECRATED)) {
                persistent = (Integer)stack.getOrDefault((Supplier)EidolonDataComponents.CONSECRATED, (Object)0);
                if (darkReputation <= lightReputation && lightReputation != 0.0 && persistent <= 50) {
                    stack.set((Supplier)EidolonDataComponents.CONSECRATED, (Object)51);
                }
                if (!(darkReputation > lightReputation) || persistent <= 50) continue;
                stack.remove((Supplier)EidolonDataComponents.CONSECRATED);
                continue;
            }
            if (!(darkReputation <= lightReputation) || lightReputation == 0.0) continue;
            stack.set((Supplier)EidolonDataComponents.CONSECRATED, (Object)51);
        }
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        ItemStack toolStack = ctx.getItemInHand();
        Direction facing = ctx.getClickedFace();
        RandomSource random = ctx.getPlayer() != null ? ctx.getPlayer().getRandom() : ctx.getLevel().getRandom();
        float hardness = state.getDestroySpeed((BlockGetter)ctx.getLevel(), ctx.getClickedPos());
        if ((block instanceof BushBlock || block instanceof LeavesBlock || state.is(BlockTags.LEAVES) || state.is(BlockTags.CROPS) || state.is(BlockTags.FLOWERS) || block instanceof GrowingPlantBlock || block instanceof HerbBlockBase) && hardness < 5.0f && hardness >= 0.0f) {
            if (!ctx.getLevel().isClientSide) {
                Vec3 hit = ctx.getClickLocation();
                ((ServerLevel)ctx.getLevel()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), hit.x, hit.y, hit.z, 3, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, (double)0.05f);
                ctx.getLevel().playSound(null, ctx.getClickedPos(), SoundEvents.SHEEP_SHEAR, SoundSource.PLAYERS, 0.5f, 0.9f + random.nextFloat() * 0.2f);
                if (random.nextInt(3) == 0) {
                    if (state.is(Registry.PLANTER_PLANTS)) {
                        if ((Integer)state.getValue((Property)HerbBlockBase.AGE) >= 2) {
                            ctx.getLevel().setBlockAndUpdate(ctx.getClickedPos(), (BlockState)state.setValue((Property)HerbBlockBase.AGE, (Comparable)Integer.valueOf(0)));
                            ItemStack drop = AllRounderItem.getHarvestable(block, ctx.getLevel());
                            if (!drop.isEmpty() && !ctx.getLevel().isClientSide) {
                                ctx.getLevel().playSound(null, ctx.getClickedPos(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.5f, 0.9f + random.nextFloat() * 0.2f);
                                for (int i = -1; i < random.nextInt(3); ++i) {
                                    ctx.getLevel().addFreshEntity((Entity)new ItemEntity(ctx.getLevel(), (double)ctx.getClickedPos().getX() + 0.5, (double)ctx.getClickedPos().getY() + 0.5, (double)ctx.getClickedPos().getZ() + 0.5, drop.copy()));
                                }
                            }
                            if (!ctx.getPlayer().isCreative()) {
                                ctx.getItemInHand().hurtAndBreak(1, (LivingEntity)ctx.getPlayer(), LivingEntity.getSlotForHand((InteractionHand)ctx.getHand()));
                            }
                        }
                    } else {
                        if (block instanceof DoublePlantBlock && state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER) {
                            ctx.getLevel().destroyBlock(ctx.getClickedPos().below(), false);
                        } else {
                            ctx.getLevel().destroyBlock(ctx.getClickedPos(), false);
                        }
                        Optional enchantmentHolder = ctx.getLevel().registryAccess().holder(Enchantments.LOOTING);
                        if (random.nextInt(10) >= 8 - (enchantmentHolder.isPresent() && ctx.getItemInHand().getItem() instanceof AthameItem ? ctx.getItemInHand().getEnchantmentLevel((Holder)enchantmentHolder.get()) : 0)) {
                            ItemStack drop = AllRounderItem.getHarvestable(block, ctx.getLevel());
                            if (!drop.isEmpty() && !ctx.getLevel().isClientSide) {
                                ctx.getLevel().playSound(null, ctx.getClickedPos(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.5f, 0.9f + random.nextFloat() * 0.2f);
                                ctx.getLevel().addFreshEntity((Entity)new ItemEntity(ctx.getLevel(), (double)ctx.getClickedPos().getX() + 0.5, (double)ctx.getClickedPos().getY() + 0.5, (double)ctx.getClickedPos().getZ() + 0.5, drop.copy()));
                            }
                            if (!ctx.getPlayer().isCreative()) {
                                ctx.getItemInHand().hurtAndBreak(1, (LivingEntity)ctx.getPlayer(), LivingEntity.getSlotForHand((InteractionHand)ctx.getHand()));
                            }
                        }
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (state.getBlock() == Blocks.PUMPKIN && toolStack.is(ModTags.KNIVES)) {
            Player player = ctx.getPlayer();
            if (player != null && !level.isClientSide) {
                Direction direction = facing.getAxis() == Direction.Axis.Y ? player.getDirection().getOpposite() : facing;
                level.playSound(null, pos, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.setBlock(pos, (BlockState)Blocks.CARVED_PUMPKIN.defaultBlockState().setValue((Property)CarvedPumpkinBlock.FACING, (Comparable)direction), 11);
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5 + (double)direction.getStepX() * 0.65, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5 + (double)direction.getStepZ() * 0.65, new ItemStack((ItemLike)Items.PUMPKIN_SEEDS, 4));
                itemEntity.setDeltaMovement(0.05 * (double)direction.getStepX() + level.random.nextDouble() * 0.02, 0.05, 0.05 * (double)direction.getStepZ() + level.random.nextDouble() * 0.02);
                level.addFreshEntity((Entity)itemEntity);
                toolStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)ctx.getHand()));
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useOn(ctx);
    }

    public static void initHarvestables() {
        harvestables.put((Block)Registry.MERAMMER_ROOT.get(), new ItemStack((ItemLike)Registry.MERAMMER_ROOT.get()));
        harvestables.put((Block)Registry.OANNA_BLOOM.get(), new ItemStack((ItemLike)Registry.OANNA_BLOOM.get()));
        harvestables.put((Block)Registry.SILDRIAN_SEED.get(), new ItemStack((ItemLike)Registry.SILDRIAN_SEED.get()));
        harvestables.put((Block)Registry.AVENNIAN_SPRIG.get(), new ItemStack((ItemLike)Registry.AVENNIAN_SPRIG.get()));
        harvestables.put((Block)Registry.MIRECAP.get(), new ItemStack((ItemLike)Registry.MIRECAP.get()));
    }

    public static ItemStack getHarvestable(Block block, Level level) {
        ItemStack harvest = level.getRecipeManager().getAllRecipesFor((RecipeType)EidolonRecipes.FORAGING_TYPE.get()).stream().map(RecipeHolder::value).filter(foragingRecipe -> foragingRecipe.block.test(new ItemStack((ItemLike)block))).map(f -> f.getResultItem((HolderLookup.Provider)level.registryAccess())).findFirst().orElse(ItemStack.EMPTY);
        if (!harvest.isEmpty()) {
            return harvest;
        }
        return harvestables.getOrDefault(block, ItemStack.EMPTY);
    }
}

