/*
 * Decompiled with CFR 0.152.
 */
package cn.nutminds.eidolonedoni.item;

import cn.nutminds.eidolonedoni.EEConfig;
import cn.nutminds.eidolonedoni.EidolonEdoni;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.ConsumableItem;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class MerammerFoodItem
extends ConsumableItem {
    public static final TagKey<MobEffect> MERAMMER_FOOD_BLACKLIST = MerammerFoodItem.create("merammer_food_blacklist");

    private static TagKey<MobEffect> create(String string) {
        return TagKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)EidolonEdoni.modid(string));
    }

    public MerammerFoodItem(Item.Properties properties) {
        super(properties);
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
        MobEffectInstance selectedEffect;
        Iterator itr = consumer.getActiveEffects().iterator();
        ArrayList<Holder> compatibleEffects = new ArrayList<Holder>();
        while (itr.hasNext()) {
            MobEffectInstance effect = (MobEffectInstance)itr.next();
            if (!((MobEffect)effect.getEffect().value()).getCategory().equals((Object)MobEffectCategory.BENEFICIAL)) continue;
            compatibleEffects.add(effect.getEffect());
        }
        level.registryAccess().registryOrThrow(Registries.MOB_EFFECT).getTagOrEmpty(MERAMMER_FOOD_BLACKLIST).forEach(compatibleEffects::remove);
        if (!compatibleEffects.isEmpty() && (selectedEffect = consumer.getEffect((Holder)compatibleEffects.get(level.random.nextInt(compatibleEffects.size())))) != null) {
            if (selectedEffect.getDuration() >= 0) {
                consumer.removeEffect(selectedEffect.getEffect());
            }
            consumer.addEffect(new MobEffectInstance(selectedEffect.getEffect(), selectedEffect.getDuration() / (Integer)EEConfig.MERAMMER_FOOD_DURATION_RATE.get(), selectedEffect.getAmplifier() + 1));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            MutableComponent textEmpty = Component.translatable((String)"eidolon_edoni.tooltip.merammer_food", (Object[])new Object[0]);
            tooltip.add((Component)textEmpty.withStyle(ChatFormatting.BLUE));
            Objects.requireNonNull(tooltip);
            TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip::add, (float)1.0f, (float)context.tickRate());
        }
    }
}

