/*
 * Decompiled with CFR 0.152.
 */
package cx.ajneb97.config;

import cx.ajneb97.Codex;
import cx.ajneb97.config.CategoriesConfigManager;
import cx.ajneb97.config.InventoryConfigManager;
import cx.ajneb97.config.MainConfigManager;
import cx.ajneb97.config.MessagesConfigManager;
import cx.ajneb97.config.PlayersConfigManager;

public class ConfigsManager {
    private Codex plugin;
    private MainConfigManager mainConfigManager;
    private CategoriesConfigManager categoriesConfigManager;
    private MessagesConfigManager messagesConfigManager;
    private PlayersConfigManager playersConfigManager;
    private InventoryConfigManager inventoryConfigManager;

    public ConfigsManager(Codex plugin) {
        this.plugin = plugin;
        this.mainConfigManager = new MainConfigManager(plugin);
        this.categoriesConfigManager = new CategoriesConfigManager(plugin, "categories");
        this.playersConfigManager = new PlayersConfigManager(plugin, "players");
        this.messagesConfigManager = new MessagesConfigManager(plugin);
        this.inventoryConfigManager = new InventoryConfigManager(plugin);
    }

    public void configure() {
        this.mainConfigManager.configure();
        this.categoriesConfigManager.configure();
        this.inventoryConfigManager.configure();
        this.playersConfigManager.configure();
        this.messagesConfigManager.configure();
    }

    public MainConfigManager getMainConfigManager() {
        return this.mainConfigManager;
    }

    public MessagesConfigManager getMessagesConfigManager() {
        return this.messagesConfigManager;
    }

    public PlayersConfigManager getPlayersConfigManager() {
        return this.playersConfigManager;
    }

    public boolean reload() {
        if (!this.messagesConfigManager.reloadConfig()) {
            return false;
        }
        if (!this.mainConfigManager.reloadConfig()) {
            return false;
        }
        if (!this.inventoryConfigManager.reloadConfig()) {
            return false;
        }
        this.categoriesConfigManager.loadConfigs();
        this.plugin.reloadPlayerDataSaveTask();
        this.plugin.getVerifyManager().verify();
        return true;
    }
}

