/*
 * Decompiled with CFR 0.152.
 */
package cx.ajneb97.managers;

import cx.ajneb97.Codex;
import cx.ajneb97.database.MySQLConnection;
import cx.ajneb97.managers.CategoryManager;
import cx.ajneb97.model.data.PlayerData;
import cx.ajneb97.model.data.PlayerDataCategory;
import cx.ajneb97.model.data.PlayerDataDiscovery;
import cx.ajneb97.model.structure.Category;
import cx.ajneb97.utils.OtherUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class PlayerDataManager {
    private Codex plugin;
    private Map<UUID, PlayerData> players;
    private Map<String, UUID> playerNames;

    public PlayerDataManager(Codex plugin) {
        this.plugin = plugin;
        this.playerNames = new HashMap<String, UUID>();
    }

    public Map<UUID, PlayerData> getPlayers() {
        return this.players;
    }

    public void setPlayers(Map<UUID, PlayerData> players) {
        this.players = players;
        for (Map.Entry<UUID, PlayerData> entry : players.entrySet()) {
            this.playerNames.put(entry.getValue().getName(), entry.getKey());
        }
    }

    public void addPlayer(PlayerData p) {
        this.players.put(p.getUuid(), p);
        this.playerNames.put(p.getName(), p.getUuid());
    }

    public PlayerData getPlayer(Player player, boolean create) {
        PlayerData playerData = this.players.get(player.getUniqueId());
        if (playerData == null && create) {
            playerData = new PlayerData(player.getUniqueId(), player.getName());
            this.addPlayer(playerData);
        }
        return playerData;
    }

    private void updatePlayerName(String oldName, String newName, UUID uuid) {
        if (oldName != null) {
            this.playerNames.remove(oldName);
        }
        this.playerNames.put(newName, uuid);
    }

    public PlayerData getPlayerByUUID(UUID uuid) {
        return this.players.get(uuid);
    }

    private UUID getPlayerUUID(String name) {
        return this.playerNames.get(name);
    }

    public PlayerData getPlayerByName(String name) {
        UUID uuid = this.getPlayerUUID(name);
        return this.players.get(uuid);
    }

    public void removePlayerByUUID(UUID uuid) {
        this.players.remove(uuid);
    }

    public void setJoinPlayerData(Player player) {
        if (this.plugin.getMySQLConnection() != null) {
            MySQLConnection mySQLConnection = this.plugin.getMySQLConnection();
            UUID uuid = player.getUniqueId();
            mySQLConnection.getPlayer(uuid.toString(), playerData -> {
                this.removePlayerByUUID(uuid);
                if (playerData != null) {
                    this.addPlayer(playerData);
                    if (!playerData.getName().equals(player.getName())) {
                        this.updatePlayerName(playerData.getName(), player.getName(), player.getUniqueId());
                        playerData.setName(player.getName());
                        mySQLConnection.updatePlayerName(playerData);
                    }
                } else {
                    playerData = new PlayerData(uuid, player.getName());
                    this.addPlayer(playerData);
                    mySQLConnection.createPlayer(playerData);
                }
            });
        } else {
            PlayerData playerData2 = this.getPlayer(player, false);
            if (!(playerData2 == null || playerData2.getName() != null && playerData2.getName().equals(player.getName()))) {
                this.updatePlayerName(playerData2.getName(), player.getName(), player.getUniqueId());
                playerData2.setName(player.getName());
                playerData2.setModified(true);
            }
        }
    }

    public void addDiscovery(Player player, String categoryName, String discoveryName) {
        PlayerData playerData = this.getPlayer(player, true);
        playerData.setModified(true);
        String date = OtherUtils.getDate(this.plugin.getConfigsManager().getMainConfigManager().getDiscoveriesDateFormat());
        playerData.addDiscovery(categoryName, discoveryName, date);
        if (this.plugin.getMySQLConnection() != null) {
            this.plugin.getMySQLConnection().addDiscovery(player.getUniqueId().toString(), categoryName, discoveryName, date);
        }
    }

    public boolean hasDiscovery(Player player, String categoryName, String discoveryName) {
        PlayerData playerData = this.getPlayer(player, false);
        if (playerData == null) {
            return false;
        }
        return playerData.hasDiscovery(categoryName, discoveryName);
    }

    public PlayerDataDiscovery getDiscovery(Player player, String categoryName, String discoveryName) {
        PlayerData playerData = this.getPlayer(player, false);
        if (playerData == null) {
            return null;
        }
        return playerData.getDiscovery(categoryName, discoveryName);
    }

    public int getTotalDiscoveries(Player player, String categoryName) {
        PlayerData playerData = this.getPlayer(player, false);
        if (playerData == null) {
            return 0;
        }
        return playerData.getTotalDiscoveries(categoryName);
    }

    public int getTotalDiscoveries(Player player) {
        PlayerData playerData = this.getPlayer(player, false);
        if (playerData == null) {
            return 0;
        }
        return playerData.getTotalDiscoveries();
    }

    public int getTotalDiscoveriesPercentage(Player player, String categoryName, int max) {
        int totalDiscoveries = this.getTotalDiscoveries(player, categoryName);
        return OtherUtils.getPercentage(totalDiscoveries, max);
    }

    public int getTotalDiscoveriesPercentage(Player player, int max) {
        int totalDiscoveries = this.getTotalDiscoveries(player);
        return OtherUtils.getPercentage(totalDiscoveries, max);
    }

    public void completeCategory(Player player, String categoryName) {
        PlayerData playerData = this.getPlayer(player, true);
        playerData.completeCategory(categoryName);
        if (this.plugin.getMySQLConnection() != null) {
            this.plugin.getMySQLConnection().updateCompletedCategories(player.getUniqueId().toString(), categoryName);
        }
    }

    public boolean hasAllDiscoveries(Player player, String categoryName, int totalDiscoveries) {
        PlayerData playerData = this.getPlayer(player, false);
        if (playerData == null) {
            return false;
        }
        return playerData.getTotalDiscoveries(categoryName) >= totalDiscoveries;
    }

    public List<PlayerDataCategory> getCategories(Player player) {
        PlayerData playerData = this.getPlayer(player, false);
        if (playerData == null) {
            return new ArrayList<PlayerDataCategory>();
        }
        return playerData.getCategories();
    }

    public boolean hasCompletedCategory(Player player, String categoryName) {
        PlayerData playerData = this.getPlayer(player, false);
        if (playerData == null) {
            return false;
        }
        return playerData.isCategoryCompleted(categoryName);
    }

    public boolean hasCompletedCategory(String playerName, String categoryName) {
        PlayerData playerData = this.getPlayerByName(playerName);
        if (playerData == null) {
            return false;
        }
        return playerData.isCategoryCompleted(categoryName);
    }

    public void setMillisActionsExecuted(Player player, String categoryName, String discoveryName) {
        PlayerData playerData = this.getPlayer(player, true);
        playerData.setModified(true);
        playerData.setMillisActionsExecuted(categoryName, discoveryName);
        if (this.plugin.getMySQLConnection() != null) {
            this.plugin.getMySQLConnection().updateMillisActionsExecuted(player.getUniqueId().toString(), categoryName, discoveryName);
        }
    }

    public long getMillisActionsExecuted(Player player, String categoryName, String discoveryName) {
        PlayerData playerData = this.getPlayer(player, false);
        if (playerData == null) {
            return 0L;
        }
        return playerData.getMillisActionsExecuted(categoryName, discoveryName);
    }

    public String resetDataPlayer(String playerName, String categoryName, String discoveryName, FileConfiguration messagesConfig) {
        PlayerData playerData = this.getPlayerByName(playerName);
        if (!playerName.equals("*") && playerData == null) {
            return messagesConfig.getString("playerDoesNotExists");
        }
        CategoryManager categoryManager = this.plugin.getCategoryManager();
        if (categoryName != null) {
            Category category = categoryManager.getCategory(categoryName);
            if (category == null) {
                return messagesConfig.getString("categoryDoesNotExist");
            }
            if (discoveryName != null && category.getDiscovery(discoveryName) == null) {
                return messagesConfig.getString("discoveryDoesNotExist").replace("%category%", categoryName);
            }
        }
        MySQLConnection mySQLConnection = this.plugin.getMySQLConnection();
        if (categoryName == null) {
            if (playerName.equals("*")) {
                for (Map.Entry<UUID, PlayerData> entry : this.players.entrySet()) {
                    entry.getValue().resetData();
                }
                if (mySQLConnection != null) {
                    mySQLConnection.resetDataPlayer("*", null, null);
                }
                return messagesConfig.getString("commandResetAllForAllPlayers");
            }
            playerData.resetData();
            if (mySQLConnection != null) {
                mySQLConnection.resetDataPlayer(playerData.getUuid().toString(), null, null);
            }
            return messagesConfig.getString("commandResetAllForPlayer").replace("%player%", playerName);
        }
        if (discoveryName == null) {
            if (playerName.equals("*")) {
                for (Map.Entry<UUID, PlayerData> entry : this.players.entrySet()) {
                    entry.getValue().resetCategory(categoryName);
                }
                if (mySQLConnection != null) {
                    mySQLConnection.resetDataPlayer("*", categoryName, null);
                }
                return messagesConfig.getString("commandResetCategoryForAllPlayers").replace("%category%", categoryName);
            }
            playerData.resetCategory(categoryName);
            if (mySQLConnection != null) {
                mySQLConnection.resetDataPlayer(playerData.getUuid().toString(), categoryName, null);
            }
            return messagesConfig.getString("commandResetCategoryForPlayer").replace("%player%", playerName).replace("%category%", categoryName);
        }
        if (playerName.equals("*")) {
            for (Map.Entry<UUID, PlayerData> entry : this.players.entrySet()) {
                entry.getValue().resetDiscovery(categoryName, discoveryName);
            }
            if (mySQLConnection != null) {
                mySQLConnection.resetDataPlayer("*", categoryName, discoveryName);
            }
            return messagesConfig.getString("commandResetDiscoveryForAllPlayers").replace("%category%", categoryName).replace("%discovery%", discoveryName);
        }
        playerData.resetDiscovery(categoryName, discoveryName);
        if (mySQLConnection != null) {
            mySQLConnection.resetDataPlayer(playerData.getUuid().toString(), categoryName, discoveryName);
        }
        return messagesConfig.getString("commandResetDiscoveryForPlayer").replace("%player%", playerName).replace("%category%", categoryName).replace("%discovery%", discoveryName);
    }
}

