/*
 * Decompiled with CFR 0.152.
 */
package cx.ajneb97.managers;

import cx.ajneb97.Codex;
import cx.ajneb97.config.MainConfigManager;
import cx.ajneb97.managers.CommonItemManager;
import cx.ajneb97.managers.MessagesManager;
import cx.ajneb97.managers.PlayerDataManager;
import cx.ajneb97.model.data.PlayerDataDiscovery;
import cx.ajneb97.model.internal.CommonVariable;
import cx.ajneb97.model.inventory.CommonInventory;
import cx.ajneb97.model.inventory.CommonInventoryItem;
import cx.ajneb97.model.inventory.InventoryPlayer;
import cx.ajneb97.model.item.CommonItem;
import cx.ajneb97.model.structure.Category;
import cx.ajneb97.model.structure.Discovery;
import cx.ajneb97.utils.ActionUtils;
import cx.ajneb97.utils.ItemUtils;
import cx.ajneb97.utils.OtherUtils;
import cx.ajneb97.utils.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryManager {
    private Codex plugin;
    private ArrayList<CommonInventory> inventories;
    private ArrayList<InventoryPlayer> players;

    public InventoryManager(Codex plugin) {
        this.plugin = plugin;
        this.inventories = new ArrayList();
        this.players = new ArrayList();
    }

    public ArrayList<CommonInventory> getInventories() {
        return this.inventories;
    }

    public void setInventories(ArrayList<CommonInventory> inventories) {
        this.inventories = inventories;
    }

    public ArrayList<InventoryPlayer> getPlayers() {
        return this.players;
    }

    public CommonInventory getInventory(String name) {
        for (CommonInventory inventory : this.inventories) {
            if (!inventory.getName().equals(name)) continue;
            return inventory;
        }
        return null;
    }

    public InventoryPlayer getInventoryPlayer(Player player) {
        for (InventoryPlayer inventoryPlayer : this.players) {
            if (!inventoryPlayer.getPlayer().equals((Object)player)) continue;
            return inventoryPlayer;
        }
        return null;
    }

    public void removeInventoryPlayer(Player player) {
        this.players.removeIf(p -> p.getPlayer().equals((Object)player));
    }

    public void openInventory(InventoryPlayer inventoryPlayer) {
        CommonInventory inventory = this.getInventory(inventoryPlayer.getInventoryName());
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        String title = inventory.getTitle();
        Inventory inv = mainConfigManager.isUseMiniMessage() ? Bukkit.createInventory(null, (int)inventory.getSlots(), (Component)MiniMessage.miniMessage().deserialize((Object)title)) : Bukkit.createInventory(null, (int)inventory.getSlots(), (String)MessagesManager.getLegacyColoredMessage(title));
        List<CommonInventoryItem> items = inventory.getItems();
        CommonItemManager commonItemManager = this.plugin.getCommonItemManager();
        Player player = inventoryPlayer.getPlayer();
        for (CommonInventoryItem itemInventory : items) {
            for (int slot : itemInventory.getSlots()) {
                ItemStack item;
                String type = itemInventory.getType();
                if (type != null) {
                    item = null;
                    if (type.startsWith("discovery: ")) {
                        item = this.setDiscovery(type.replace("discovery: ", ""), inventoryPlayer);
                    } else if (type.startsWith("category: ")) {
                        item = this.setCategory(type.replace("category: ", ""), player);
                    }
                    if (item == null) continue;
                    item = this.setItemActions(itemInventory, item);
                    inv.setItem(slot, item);
                    continue;
                }
                item = commonItemManager.createItemFromCommonItem(itemInventory.getItem(), player);
                String openInventory = itemInventory.getOpenInventory();
                if (openInventory != null) {
                    item = ItemUtils.setTagStringItem(this.plugin, item, "codex_open_inventory", openInventory);
                }
                item = this.setItemActions(itemInventory, item);
                inv.setItem(slot, item);
            }
        }
        inventoryPlayer.getPlayer().openInventory(inv);
        this.players.add(inventoryPlayer);
    }

    private ItemStack setItemActions(CommonInventoryItem commonItem, ItemStack item) {
        List<String> clickActions = commonItem.getClickActions();
        if (clickActions != null && !clickActions.isEmpty()) {
            String actionsList = "";
            for (int i = 0; i < clickActions.size(); ++i) {
                actionsList = i == clickActions.size() - 1 ? actionsList + clickActions.get(i) : actionsList + clickActions.get(i) + "|";
            }
            item = ItemUtils.setTagStringItem(this.plugin, item, "codex_item_actions", actionsList);
        }
        return item;
    }

    private void clickOnDiscoveryItem(InventoryPlayer inventoryPlayer, String discoveryName, ClickType clickType) {
        String categoryName = inventoryPlayer.getInventoryName().replace("category_", "").split(";")[0];
        Category category = this.plugin.getCategoryManager().getCategory(categoryName);
        if (category == null) {
            return;
        }
        Discovery discovery = category.getDiscovery(discoveryName);
        if (discovery == null) {
            return;
        }
        Player player = inventoryPlayer.getPlayer();
        PlayerDataManager playerDataManager = this.plugin.getPlayerDataManager();
        boolean hasDiscovered = playerDataManager.hasDiscovery(player, category.getName(), discoveryName);
        if (!hasDiscovered) {
            return;
        }
        List<String> actions = discovery.getClickActions();
        if (actions != null) {
            int cooldown = discovery.getClickActionsCooldown();
            if (cooldown != 0) {
                long millisActionsExecuted = playerDataManager.getMillisActionsExecuted(player, category.getName(), discoveryName);
                long millisAvailable = millisActionsExecuted + (long)cooldown * 1000L;
                long currentMillis = System.currentTimeMillis();
                if (millisActionsExecuted != 0L && millisAvailable > currentMillis) {
                    FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
                    MessagesManager msgManager = this.plugin.getMessagesManager();
                    String timeString = TimeUtils.getTime((millisAvailable - currentMillis) / 1000L, msgManager);
                    msgManager.sendMessage((CommandSender)player, messagesConfig.getString("clickActionsCooldown").replace("%time%", timeString), true);
                    return;
                }
                playerDataManager.setMillisActionsExecuted(player, category.getName(), discoveryName);
            }
            for (String action : actions) {
                ActionUtils.executeAction(player, action, this.plugin, new ArrayList<CommonVariable>());
            }
        }
    }

    private void clickOnCategoryItem(InventoryPlayer inventoryPlayer, String categoryName, ClickType clickType) {
        Category category = this.plugin.getCategoryManager().getCategory(categoryName);
        if (category == null) {
            return;
        }
        Player player = inventoryPlayer.getPlayer();
        inventoryPlayer.setInventoryName("category_" + categoryName);
        this.openInventory(inventoryPlayer);
    }

    private void clickOnOpenInventoryItem(InventoryPlayer inventoryPlayer, String openInventory) {
        inventoryPlayer.setInventoryName(openInventory);
        this.openInventory(inventoryPlayer);
    }

    private void clickActionsItem(InventoryPlayer inventoryPlayer, String itemCommands) {
        String[] sep;
        for (String action : sep = itemCommands.split("\\|")) {
            ActionUtils.executeAction(inventoryPlayer.getPlayer(), action, this.plugin, new ArrayList<CommonVariable>());
        }
    }

    public void clickInventory(InventoryPlayer inventoryPlayer, ItemStack item, ClickType clickType) {
        String categoryName;
        String itemActions = ItemUtils.getTagStringItem(this.plugin, item, "codex_item_actions");
        if (itemActions != null) {
            this.clickActionsItem(inventoryPlayer, itemActions);
        }
        if ((categoryName = ItemUtils.getTagStringItem(this.plugin, item, "codex_category")) != null) {
            this.clickOnCategoryItem(inventoryPlayer, categoryName, clickType);
            return;
        }
        String discoveryName = ItemUtils.getTagStringItem(this.plugin, item, "codex_discovery");
        if (discoveryName != null) {
            this.clickOnDiscoveryItem(inventoryPlayer, discoveryName, clickType);
            return;
        }
        String openInventory = ItemUtils.getTagStringItem(this.plugin, item, "codex_open_inventory");
        if (openInventory != null) {
            this.clickOnOpenInventoryItem(inventoryPlayer, openInventory);
            return;
        }
    }

    public ItemStack setCategory(String categoryName, Player player) {
        Category category = this.plugin.getCategoryManager().getCategory(categoryName);
        if (category == null) {
            return null;
        }
        PlayerDataManager playerDataManager = this.plugin.getPlayerDataManager();
        CommonItemManager commonItemManager = this.plugin.getCommonItemManager();
        ArrayList<CommonVariable> variables = new ArrayList<CommonVariable>();
        int max = category.getDiscoveries().size();
        int totalDiscoveries = playerDataManager.getTotalDiscoveries(player, categoryName);
        String unlockedVariable = OtherUtils.getCurrentUnlockedVariable(totalDiscoveries, max, this.plugin.getMessagesConfig());
        CommonItem commonItem = category.getCategoryItem();
        variables.add(new CommonVariable("%progress_bar%", OtherUtils.getProgressBar(totalDiscoveries, max, this.plugin.getConfigsManager().getMainConfigManager())));
        variables.add(new CommonVariable("%percentage%", OtherUtils.getPercentage(totalDiscoveries, max) + "%"));
        variables.add(new CommonVariable("%unlocked%", unlockedVariable));
        ItemStack item = commonItemManager.createItemFromCommonItem(commonItem, player);
        commonItemManager.replaceVariables(item, variables, player);
        item = ItemUtils.setTagStringItem(this.plugin, item, "codex_category", categoryName);
        return item;
    }

    public ItemStack setDiscovery(String discoveryName, InventoryPlayer inventoryPlayer) {
        ItemStack item;
        String categoryName = inventoryPlayer.getInventoryName().replace("category_", "").split(";")[0];
        Category category = this.plugin.getCategoryManager().getCategory(categoryName);
        if (category == null) {
            return null;
        }
        Discovery discovery = category.getDiscovery(discoveryName);
        if (discovery == null) {
            return null;
        }
        Player player = inventoryPlayer.getPlayer();
        PlayerDataManager playerDataManager = this.plugin.getPlayerDataManager();
        CommonItemManager commonItemManager = this.plugin.getCommonItemManager();
        ArrayList<CommonVariable> variables = new ArrayList<CommonVariable>();
        PlayerDataDiscovery playerDataDiscovery = playerDataManager.getDiscovery(player, category.getName(), discoveryName);
        if (playerDataDiscovery != null) {
            item = discovery.getCustomLevelUnlockedItem() != null ? commonItemManager.createItemFromCommonItem(discovery.getCustomLevelUnlockedItem(), player) : commonItemManager.createItemFromCommonItem(category.getDefaultLevelUnlockedItem(), player);
            variables.add(new CommonVariable("%name%", discovery.getName()));
            variables.add(new CommonVariable("%date%", playerDataDiscovery.getDiscoverDate()));
        } else {
            item = discovery.getCustomLevelBlockedItem() != null ? commonItemManager.createItemFromCommonItem(discovery.getCustomLevelBlockedItem(), player) : commonItemManager.createItemFromCommonItem(category.getDefaultLevelBlockedItem(), player);
        }
        ItemMeta meta = item.getItemMeta();
        List<String> description = discovery.getDescription();
        if (this.plugin.getConfigsManager().getMainConfigManager().isUseMiniMessage()) {
            ArrayList<Component> newLore = new ArrayList<Component>();
            List lore = meta.lore();
            PlainTextComponentSerializer plainSerializer = PlainTextComponentSerializer.plainText();
            for (Component c : lore) {
                String plainText = plainSerializer.serialize(c);
                if (plainText.contains("%description%")) {
                    for (String line : description) {
                        newLore.add(MiniMessage.miniMessage().deserialize((Object)line).decoration(TextDecoration.ITALIC, false));
                    }
                    continue;
                }
                newLore.add(c);
            }
            meta.lore(newLore);
        } else {
            ArrayList<String> newLore = new ArrayList<String>();
            List lore = meta.getLore();
            for (String s : lore) {
                if (s.contains("%description%")) {
                    for (String line : description) {
                        newLore.add(MessagesManager.getLegacyColoredMessage(line));
                    }
                    continue;
                }
                newLore.add(MessagesManager.getLegacyColoredMessage(s));
            }
            meta.setLore(newLore);
        }
        item.setItemMeta(meta);
        commonItemManager.replaceVariables(item, variables, player);
        item = ItemUtils.setTagStringItem(this.plugin, item, "codex_discovery", discoveryName);
        return item;
    }
}

