/*
 * Decompiled with CFR 0.152.
 */
package cx.ajneb97.model.data;

import cx.ajneb97.model.data.PlayerDataCategory;
import cx.ajneb97.model.data.PlayerDataDiscovery;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class PlayerData {
    private UUID uuid;
    private String name;
    private List<PlayerDataCategory> categories;
    private boolean modified;

    public PlayerData(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
        this.modified = false;
        this.categories = new ArrayList<PlayerDataCategory>();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<PlayerDataCategory> getCategories() {
        return this.categories;
    }

    public void setCategories(List<PlayerDataCategory> categories) {
        this.categories = categories;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public PlayerDataCategory getCategory(String categoryName) {
        for (PlayerDataCategory playerDataCategory : this.categories) {
            if (!playerDataCategory.getName().equals(categoryName)) continue;
            return playerDataCategory;
        }
        return null;
    }

    public void addDiscovery(String category, String discovery, String date) {
        PlayerDataCategory playerDataCategory = this.getCategory(category);
        if (playerDataCategory == null) {
            playerDataCategory = new PlayerDataCategory(category, false, new ArrayList<PlayerDataDiscovery>());
            this.categories.add(playerDataCategory);
        }
        playerDataCategory.addDiscovery(new PlayerDataDiscovery(discovery, date, 0L));
    }

    public boolean hasDiscovery(String category, String discovery) {
        PlayerDataCategory playerDataCategory = this.getCategory(category);
        if (playerDataCategory == null) {
            return false;
        }
        return playerDataCategory.hasDiscovery(discovery);
    }

    public PlayerDataDiscovery getDiscovery(String category, String discovery) {
        PlayerDataCategory playerDataCategory = this.getCategory(category);
        if (playerDataCategory == null) {
            return null;
        }
        return playerDataCategory.getDiscovery(discovery);
    }

    public int getTotalDiscoveries(String category) {
        PlayerDataCategory playerDataCategory = this.getCategory(category);
        if (playerDataCategory == null) {
            return 0;
        }
        return playerDataCategory.getDiscoveries().size();
    }

    public int getTotalDiscoveries() {
        int total = 0;
        for (PlayerDataCategory c : this.categories) {
            total += c.getDiscoveries().size();
        }
        return total;
    }

    public void completeCategory(String category) {
        PlayerDataCategory playerDataCategory = this.getCategory(category);
        if (playerDataCategory == null) {
            playerDataCategory = new PlayerDataCategory(category, false, new ArrayList<PlayerDataDiscovery>());
            this.categories.add(playerDataCategory);
        }
        playerDataCategory.setCompleted(true);
    }

    public boolean isCategoryCompleted(String category) {
        PlayerDataCategory playerDataCategory = this.getCategory(category);
        if (playerDataCategory == null) {
            return false;
        }
        return playerDataCategory.isCompleted();
    }

    public void setMillisActionsExecuted(String category, String discovery) {
        PlayerDataCategory playerDataCategory = this.getCategory(category);
        if (playerDataCategory == null) {
            return;
        }
        playerDataCategory.setMillisActionsExecuted(discovery);
    }

    public long getMillisActionsExecuted(String category, String discovery) {
        PlayerDataCategory playerDataCategory = this.getCategory(category);
        if (playerDataCategory == null) {
            return 0L;
        }
        return playerDataCategory.getMillisActionsExecuted(discovery);
    }

    public void resetData() {
        this.categories = new ArrayList<PlayerDataCategory>();
        this.modified = true;
    }

    public void resetCategory(String category) {
        this.categories.removeIf(c -> c.getName().equals(category));
        this.modified = true;
    }

    public void resetDiscovery(String category, String discovery) {
        PlayerDataCategory playerDataCategory = this.getCategory(category);
        if (playerDataCategory != null) {
            playerDataCategory.resetDiscovery(discovery);
            this.modified = true;
        }
    }
}

