/*
 * Decompiled with CFR 0.152.
 */
package cx.ajneb97.utils;

import cx.ajneb97.Codex;
import cx.ajneb97.api.CodexAPI;
import cx.ajneb97.libs.titles.TitleAPI;
import cx.ajneb97.managers.MessagesManager;
import cx.ajneb97.model.internal.CommonVariable;
import cx.ajneb97.utils.OtherUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class ActionUtils {
    public static void executeAction(Player player, String actionText, Codex plugin, ArrayList<CommonVariable> variables) {
        if (actionText.equals("close_inventory")) {
            player.closeInventory();
            return;
        }
        int indexFirst = actionText.indexOf(" ");
        String actionType = actionText.substring(0, indexFirst).replace(":", "");
        String actionLine = actionText.substring(indexFirst + 1);
        actionLine = OtherUtils.replaceGlobalVariables(actionLine, player, plugin);
        for (CommonVariable variable : variables) {
            actionLine = actionLine.replace(variable.getVariable(), variable.getValue());
        }
        switch (actionType) {
            case "message": {
                ActionUtils.message(player, actionLine);
                break;
            }
            case "centered_message": {
                ActionUtils.centeredMessage(player, actionLine);
                break;
            }
            case "console_command": {
                ActionUtils.consoleCommand(actionLine);
                break;
            }
            case "player_command": {
                ActionUtils.playerCommand(player, actionLine);
                break;
            }
            case "playsound": {
                ActionUtils.playSound(player, actionLine);
                break;
            }
            case "title": {
                ActionUtils.title(player, actionLine);
            }
        }
    }

    public static void playSound(Player player, String soundLine) {
        String[] sep = soundLine.split(";");
        Sound sound = null;
        float volume = 0.0f;
        float pitch = 0.0f;
        try {
            sound = ActionUtils.getSoundByName(sep[0]);
            volume = Float.parseFloat(sep[1]);
            pitch = Float.parseFloat(sep[2]);
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(Codex.prefix + MessagesManager.getLegacyColoredMessage("&7Sound Name: &c" + sep[0] + " &7is not valid. Change it in the config!"));
            return;
        }
        player.playSound(player.getLocation(), sound, volume, pitch);
    }

    private static Sound getSoundByName(String name) {
        try {
            Class<?> soundTypeClass = Class.forName("org.bukkit.Sound");
            Method valueOf = soundTypeClass.getMethod("valueOf", String.class);
            return (Sound)valueOf.invoke(null, name);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void consoleCommand(String actionLine) {
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        Bukkit.dispatchCommand((CommandSender)sender, (String)actionLine);
    }

    public static void playerCommand(Player player, String actionLine) {
        player.performCommand(actionLine);
    }

    public static void message(Player player, String actionLine) {
        if (CodexAPI.getPlugin().getConfigsManager().getMainConfigManager().isUseMiniMessage()) {
            player.sendMessage(MiniMessage.miniMessage().deserialize((Object)actionLine));
        } else {
            player.sendMessage(MessagesManager.getLegacyColoredMessage(actionLine));
        }
    }

    public static void centeredMessage(Player player, String actionLine) {
        if (CodexAPI.getPlugin().getConfigsManager().getMainConfigManager().isUseMiniMessage()) {
            MiniMessage mm = MiniMessage.miniMessage();
            Component component = mm.deserialize((Object)actionLine);
            String centeredTextLegacy = MessagesManager.getCenteredMessage(LegacyComponentSerializer.legacySection().serialize(component));
            TextComponent centeredTextMiniMessage = LegacyComponentSerializer.legacySection().deserialize(centeredTextLegacy);
            player.sendMessage((Component)centeredTextMiniMessage);
        } else {
            actionLine = MessagesManager.getLegacyColoredMessage(actionLine);
            player.sendMessage(MessagesManager.getCenteredMessage(actionLine));
        }
    }

    public static void title(Player player, String actionLine) {
        String[] sep = actionLine.split(";");
        int fadeIn = Integer.parseInt(sep[0]);
        int stay = Integer.parseInt(sep[1]);
        int fadeOut = Integer.parseInt(sep[2]);
        String title = sep[3];
        String subtitle = sep[4];
        if (title.equals("none")) {
            title = "";
        }
        if (subtitle.equals("none")) {
            subtitle = "";
        }
        TitleAPI.sendTitle(player, fadeIn, stay, fadeOut, title, subtitle);
    }
}

