/*
 * Decompiled with CFR 0.152.
 */
package cx.ajneb97.config;

import cx.ajneb97.Codex;
import cx.ajneb97.config.CommonConfig;
import java.io.File;
import java.util.ArrayList;

public abstract class DataFolderConfigManager {
    protected Codex plugin;
    protected String folderName;

    public DataFolderConfigManager(Codex plugin, String folderName) {
        this.plugin = plugin;
        this.folderName = folderName;
    }

    public void configure() {
        this.createFolder();
        this.loadConfigs();
    }

    public void createFolder() {
        try {
            File folder = new File(this.plugin.getDataFolder() + File.separator + this.folderName);
            if (!folder.exists()) {
                folder.mkdirs();
                this.createFiles();
            }
        }
        catch (SecurityException e) {
            Object folder = null;
        }
    }

    public CommonConfig getConfigFile(String pathName) {
        CommonConfig config = new CommonConfig(pathName, this.plugin, this.folderName, true);
        config.registerConfig();
        return config;
    }

    public ArrayList<CommonConfig> getConfigs() {
        File[] listOfFiles;
        ArrayList<CommonConfig> configs = new ArrayList<CommonConfig>();
        String pathFile = this.plugin.getDataFolder() + File.separator + this.folderName;
        File folder = new File(pathFile);
        for (File file : listOfFiles = folder.listFiles()) {
            if (!file.isFile()) continue;
            String pathName = file.getName();
            CommonConfig commonConfig = new CommonConfig(pathName, this.plugin, this.folderName, true);
            commonConfig.registerConfig();
            configs.add(commonConfig);
        }
        return configs;
    }

    public abstract void createFiles();

    public abstract void loadConfigs();

    public abstract void saveConfigs();
}

