/*
 * Decompiled with CFR 0.152.
 */
package cx.ajneb97.config;

import cx.ajneb97.Codex;
import cx.ajneb97.config.CommonConfig;
import cx.ajneb97.managers.MessagesManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.bukkit.configuration.file.FileConfiguration;

public class MessagesConfigManager {
    private Codex plugin;
    private CommonConfig configFile;

    public MessagesConfigManager(Codex plugin) {
        this.plugin = plugin;
        this.configFile = new CommonConfig("messages.yml", plugin, null, false);
        this.configFile.registerConfig();
        this.checkUpdates();
    }

    public void configure() {
        FileConfiguration config = this.configFile.getConfig();
        MessagesManager messagesManager = new MessagesManager();
        messagesManager.setPrefix(config.getString("prefix"));
        messagesManager.setTimeSeconds(config.getString("seconds"));
        messagesManager.setTimeMinutes(config.getString("minutes"));
        messagesManager.setTimeHours(config.getString("hours"));
        messagesManager.setTimeDays(config.getString("days"));
        this.plugin.setMessagesManager(messagesManager);
    }

    public CommonConfig getConfigFile() {
        return this.configFile;
    }

    public boolean reloadConfig() {
        if (!this.configFile.reloadConfig()) {
            return false;
        }
        this.configure();
        return true;
    }

    public void checkUpdates() {
        Path pathConfig = Paths.get(this.configFile.getRoute(), new String[0]);
        try {
            String text = new String(Files.readAllBytes(pathConfig));
            FileConfiguration config = this.configFile.getConfig();
            if (!text.contains("clickActionsCooldown:")) {
                config.set("clickActionsCooldown", (Object)"&cYou must wait &7%time% &cbefore using this item again.");
                config.set("seconds", (Object)"s");
                config.set("minutes", (Object)"m");
                config.set("hours", (Object)"h");
                config.set("days", (Object)"d");
                this.configFile.saveConfig();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

