/*
 * Decompiled with CFR 0.152.
 */
package cx.ajneb97.config;

import cx.ajneb97.Codex;
import cx.ajneb97.config.CommonConfig;
import cx.ajneb97.config.DataFolderConfigManager;
import cx.ajneb97.model.data.PlayerData;
import cx.ajneb97.model.data.PlayerDataCategory;
import cx.ajneb97.model.data.PlayerDataDiscovery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;

public class PlayersConfigManager
extends DataFolderConfigManager {
    public PlayersConfigManager(Codex plugin, String folderName) {
        super(plugin, folderName);
    }

    @Override
    public void loadConfigs() {
        HashMap<UUID, PlayerData> players = new HashMap<UUID, PlayerData>();
        ArrayList<CommonConfig> configFiles = this.getConfigs();
        for (CommonConfig commonConfig : configFiles) {
            FileConfiguration config = commonConfig.getConfig();
            String uuidString = commonConfig.getPath().replace(".yml", "");
            String name = config.getString("name");
            ArrayList<PlayerDataCategory> playerDataCategories = new ArrayList<PlayerDataCategory>();
            if (config.contains("categories")) {
                for (String key : config.getConfigurationSection("categories").getKeys(false)) {
                    List discoveriesStringList = config.getStringList("categories." + key + ".discoveries");
                    boolean completed = config.getBoolean("categories." + key + ".completed");
                    ArrayList<PlayerDataDiscovery> discoveries = new ArrayList<PlayerDataDiscovery>();
                    for (String d : discoveriesStringList) {
                        String[] sep = d.split(";");
                        long millisActionsExecuted = 0L;
                        if (sep.length == 3) {
                            millisActionsExecuted = Long.parseLong(sep[2]);
                        }
                        discoveries.add(new PlayerDataDiscovery(sep[0], sep[1], millisActionsExecuted));
                    }
                    playerDataCategories.add(new PlayerDataCategory(key, completed, discoveries));
                }
            }
            UUID uuid = UUID.fromString(uuidString);
            PlayerData playerData = new PlayerData(uuid, name);
            playerData.setCategories(playerDataCategories);
            players.put(uuid, playerData);
        }
        this.plugin.getPlayerDataManager().setPlayers(players);
    }

    public void saveConfig(PlayerData playerData) {
        String playerName = playerData.getName();
        CommonConfig playerConfig = this.getConfigFile(playerData.getUuid() + ".yml");
        FileConfiguration config = playerConfig.getConfig();
        config.set("name", (Object)playerName);
        config.set("categories", null);
        List<PlayerDataCategory> categories = playerData.getCategories();
        for (PlayerDataCategory category : categories) {
            String path = "categories." + category.getName();
            config.set(path + ".completed", (Object)category.isCompleted());
            config.set(path + ".discoveries", category.getDiscoveriesToStringList());
        }
        playerConfig.saveConfig();
    }

    @Override
    public void saveConfigs() {
        Map<UUID, PlayerData> players = this.plugin.getPlayerDataManager().getPlayers();
        boolean isMySQL = this.plugin.getConfigsManager().getMainConfigManager().isMySQL();
        if (!isMySQL) {
            for (Map.Entry<UUID, PlayerData> entry : players.entrySet()) {
                PlayerData playerData = entry.getValue();
                if (playerData.isModified()) {
                    this.saveConfig(playerData);
                }
                playerData.setModified(false);
            }
        }
    }

    @Override
    public void createFiles() {
    }
}

