/*
 * Decompiled with CFR 0.152.
 */
package cx.ajneb97.listeners;

import cx.ajneb97.Codex;
import cx.ajneb97.managers.MessagesManager;
import org.bukkit.ChatColor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;

public class PlayerListener
implements Listener {
    private Codex plugin;

    public PlayerListener(Codex plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.plugin.getPlayerDataManager().setJoinPlayerData(event.getPlayer());
        Player player = event.getPlayer();
        String latestVersion = this.plugin.getUpdateCheckerManager().getLatestVersion();
        if (player.isOp() && this.plugin.getConfigsManager().getMainConfigManager().isUpdateNotify() && !this.plugin.version.equals(latestVersion)) {
            player.sendMessage(MessagesManager.getLegacyColoredMessage(Codex.prefix + " &cThere is a new version available. &e(&7" + latestVersion + "&e)"));
            player.sendMessage(MessagesManager.getLegacyColoredMessage("&cYou can download it at: &fhttps://modrinth.com/plugin/codex-rpg-discoveries"));
        }
    }

    @EventHandler
    public void onMobKill(EntityDeathEvent event) {
        LivingEntity e = event.getEntity();
        if (e.getKiller() != null) {
            String customName = e.getCustomName() != null ? ChatColor.stripColor((String)e.getCustomName()) : null;
            this.plugin.getDiscoveryManager().onMobKill(e.getKiller(), e.getType().name(), customName);
        }
    }
}

